package com.qiho.center.biz.service.order;

import com.qiho.center.api.dto.OrderStrategyDto;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.ordertmp.OrderTmpDetailDto;
import com.qiho.center.api.enums.ShotOrder.StrategyType;
import com.qiho.center.api.params.OrderStrategyParams;

/**
 * Created by danke on 2017/6/21.
 */
public interface OrderStrategyService {

    /**
     * 通过id查询
     *
     * @param id
     * @return
     */
    OrderStrategyDto findStrategyById(Long id);

    /**
     * 通过条件查询
     *
     * @param params
     * @return
     */
    PagenationDto<OrderStrategyDto> findStrategyByQuery(OrderStrategyParams params, Integer pageNum, Integer pageSize);

    /**
     * 更新策略
     *
     * @param orderStrategyDto
     * @return
     */
    Integer updateStrategy(OrderStrategyDto orderStrategyDto);

    /**
     * 通过id删除指定策略
     *
     * @param id
     * @return
     */
    Integer deleteStrategyById(Long id, String updator);

    /**
     * 新增策略
     *
     * @param orderStrategyDto
     * @return
     */
    Integer insertStrategy(OrderStrategyDto orderStrategyDto);

    /**
     * 通过条件查询记录数
     */
    Integer countStrategyByQuery(OrderStrategyParams params);

    /**
     * 通过策略类型查询
     *
     * @param id
     * @return
     */
    OrderStrategyDto findStrategyByStrategyType(StrategyType type);

    /**
     * 判断当前商家的订单是否需要进行手机号状态校验
     * @param merchantId 商家id
     * @param strategyType 策略类型
     * @return true-需要  false-不需要
     */
    boolean needCheckPhoneStatues(Long merchantId, StrategyType strategyType);

    /**
     * 适用于过滤规则的手机号状态检测
     * @param orderTmpDetailDto
     * @return true-通过  false-不通过
     */
    boolean checkPhoneStatusForFilterRule(OrderTmpDetailDto orderTmpDetailDto);

}
