package com.qiho.center.biz.service.order;

import com.qiho.center.api.dto.SimpleIdAndNameDto;
import com.qiho.center.common.entityd.qiho.order.StrategyMerchantEntity;

import java.util.List;

/**
 * 策略与商家关系service
 *
 * @author peanut.huang
 * @date 2018/3/15.
 */
public interface StrategyMerchantService {

    /**
     * 查询关系
     *
     * @param merchantId   商家id
     * @param strategyId   策略id
     * @return             商家策略实体
     */
    StrategyMerchantEntity find(Long merchantId, Long strategyId);

    /**
     * 删除商家策略
     *
     * @param merchantId   商家id
     * @param strategyId   策略id
     * @return
     */
    Boolean delMerchantStrategy(Long merchantId, Long strategyId);

    /**
     * 批量插入
     *
     * @param insertList
     * @return
     */
    Boolean batchInsert(List<StrategyMerchantEntity> insertList);

    /**
     * 查询策略适用的商家
     *
     * @param id  策略id
     * @return    商家id与name集
     */
    List<SimpleIdAndNameDto> findMerchants(Long id);
}
