package com.qiho.center.biz.service.ordertmp;

import com.qiho.center.api.dto.ChannelInfoDto;
import com.qiho.center.api.dto.OrderDto;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.ResultDto;
import com.qiho.center.api.dto.ordertmp.OrderTmpDetailDto;
import com.qiho.center.api.enums.ordertmp.OrderTmpRiskCheckFailEnum;
import com.qiho.center.api.params.ordertmp.OrderTmpPageParam;

/**
 * 临时订单相关Service接口
 *
 * @author chensong
 * @create 2018-05-10 11:29
 **/
public interface OrderTmpService {

    /**
     * 提交临时订单
     * @param orderDeatil
     * @return 订单编号
     */
    String submitTmpOrder(OrderTmpDetailDto orderDeatil);


    /**
     * 根据orderId查找
     * @param orderId
     * @return
     */
    OrderTmpDetailDto findByOrderId(String orderId);

    /**
     * 获取所有详情
     * @param orderId
     * @return
     */
    OrderTmpDetailDto findDetailByOrderId(String orderId);

    /**
     * 临时订单的业务校验
     * @param orderTmpDetailDto 临时订单详情
     * true - 通过   false - 不通过
     */
    boolean bizValidate(OrderTmpDetailDto orderTmpDetailDto);

    /**
     * 将临时订单变更为无效
     * @param orderId 订单编号
     * @param remark 失败备注信息
     * @param checkFailEnum 校验不通过的类型
     * @return
     */
    boolean updateOrderTmpToInvalid(String orderId, String remark, OrderTmpRiskCheckFailEnum checkFailEnum);

    /**
     * 根据orderId删除临时订单
     * @param orderId
     */
    void deleteOrderTmpByOrderId(String orderId);

    /**
     * 分页查询订单
     * @param pageParam
     * @return
     */
    PagenationDto<OrderTmpDetailDto> queryPage(OrderTmpPageParam pageParam);

    /**
     * 将临时订单变成有效
     * @param orderId
     * @return
     */
    ResultDto<Boolean> toValid(String orderId);

    /**
     * 分页查询统计
     * @param pageParam
     * @return
     */
    int countPageQuery(OrderTmpPageParam pageParam);



}
