package com.qiho.center.biz.service.page;

import com.qiho.center.api.dto.ItemDto;
import com.qiho.center.api.dto.page.CollPageDto;
import com.qiho.center.api.params.CollItemListQueryParam;

import java.util.List;

/**
 * @author jiafeng.geng
 * @date 2018-07-19.
 */
public interface CollPageService {

    /**
     * 查询集合页列表
     *
     * @return List<CollPageVO>
     */
    List<CollPageDto> queryList();

    /**
     * 新增页面模板
     *
     * @param collPageDto
     * @return Integer
     */
    Integer addCollPage(CollPageDto collPageDto);

    /**
     * 编辑页面模板
     *
     * @param collPageDto
     * @return Integer
     */
    Integer updateCollPage(CollPageDto collPageDto);

    /**
     * 查询商品信息
     *
     * @param params
     * @return List<ItemDto>
     */
    List<ItemDto> queryCollItemIndex(CollItemListQueryParam params);

    /**
     * 根据集合页id查询页面数据
     * @param id
     * @return
     */
    CollPageDto findById(Long id);
}
