package com.qiho.center.biz.service.sms.impl;

import com.qiho.center.api.dto.sms.ChuangLanSmsReportDto;
import com.qiho.center.biz.remoteservice.impl.sms.RemoteChuangLanServiceImpl;
import com.qiho.center.biz.service.sms.ChuangLanSmsCommitService;
import com.qiho.center.common.daoh.qiho.ChuangLanSmsCommitMapper;
import com.qiho.center.common.entityd.qiho.ChuangLanSmsCommitEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * Created by weny.cai on 2018/5/2.
 */
@Service
public class ChuangLanSmsCommitServiceImpl implements ChuangLanSmsCommitService {

    private static final Logger LOGGER = LoggerFactory.getLogger(RemoteChuangLanServiceImpl.class);


    @Autowired
    ChuangLanSmsCommitMapper chuangLanSmsCommitMapper;

    @Override
    public ChuangLanSmsCommitEntity getChuangLanSmsCommitEntity(ChuangLanSmsReportDto dto) {
        ChuangLanSmsCommitEntity commitEntity = chuangLanSmsCommitMapper.selectByMsgId(dto.getMsgId());
        int exceptionNum = 0;
        while (commitEntity==null){
            if(exceptionNum==10){
                LOGGER.warn("not found more than ten...");
                return null;
            }
            try {
                LOGGER.warn("not found sleep 100ms find again...");
                Thread.sleep(100);
            } catch (InterruptedException e) {
                LOGGER.warn("thread sleep error...");
            }
            commitEntity = chuangLanSmsCommitMapper.selectByMsgId(dto.getMsgId());
            exceptionNum ++;
        }
        return commitEntity;
    }
}
