package com.qiho.center.biz.service.tag;

import com.qiho.center.api.dto.CategoryDto;
import com.qiho.center.api.dto.ResultDto;
import com.qiho.center.api.dto.tag.TagTypeDto;
import com.qiho.center.api.params.tag.QueryTagTypeParam;

import java.util.List;

/**标签类型相关服务接口
 * @author chensong
 * @create 2018-03-23 09:41
 **/
public interface TagTypeService {

    /**
     * 保存标签类型
     * @param categoryIds
     * @return
     */
    ResultDto<Boolean> saveTagType(TagTypeDto tagTypeDto, List<Long> categoryIds);

    /**
     * 标签类型查询接口
     * @param param
     * @return
     */
    List<TagTypeDto> queryTagType(QueryTagTypeParam param);

    /**
     * 删除标签类型
     * @param typeId
     * @return
     */
    Boolean deleteTagType(Long typeId);

    /**
     * 根据商品id获取可以关联的标签类型
     * @param itemId
     * @return
     */
    ResultDto<List<TagTypeDto>> findByItemId(Long itemId);

    /**
     * 根据标签类型id获取已关联的类目
     * @param typeId
     * @return
     */
    List<CategoryDto> findCategoryByTypeId(Long typeId);




}
