package com.qiho.center.biz.service.task.impl;

import cn.com.duiba.wolf.utils.BeanUtils;
import com.google.common.collect.Lists;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.task.OrderConfirmTaskDto;
import com.qiho.center.api.params.task.OrderConfirmTaskPageParams;
import com.qiho.center.biz.service.task.OrderConfirmTaskService;
import com.qiho.center.common.daoh.qiho.OrderConfirmTaskDetailMapper;
import com.qiho.center.common.daoh.qiho.OrderConfirmTaskMapper;
import com.qiho.center.common.entityd.qiho.OrderConfirmTaskEntity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.BoundHashOperations;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;

/**
 * Created by weny.cai on 2018/3/19.
 */
@Service
public class OrderConfirmTaskServiceImpl implements OrderConfirmTaskService{

    @Autowired
    OrderConfirmTaskMapper orderConfirmTaskMapper;

    @Autowired
    StringRedisTemplate redisTemplate;

    @Autowired
    OrderConfirmTaskDetailMapper detailMapper;

    @Override
    public PagenationDto<OrderConfirmTaskDto> selectForPage(OrderConfirmTaskPageParams pageParams) {
        PagenationDto<OrderConfirmTaskDto> pagenationDto = new PagenationDto<>();
        List<OrderConfirmTaskEntity> result = orderConfirmTaskMapper.selectForPage(pageParams);

        if(result.isEmpty()){
            pagenationDto.setList(Lists.newArrayList());
            pagenationDto.setTotal(0);
            return pagenationDto;
        }

        int count = orderConfirmTaskMapper.selectForPageCount(pageParams);
        List<OrderConfirmTaskDto> dtos = Lists.newArrayList();
        for (OrderConfirmTaskEntity taskEntity : result) {
            OrderConfirmTaskDto dto = BeanUtils.copy(taskEntity,OrderConfirmTaskDto.class);
            if(taskEntity.getTaskStatus()==0){
                //正在处理的 计算进度  处理成功不需要
                BoundHashOperations<String, String, String> ops = redisTemplate.boundHashOps(taskEntity.getTaskId());
                Map<String, String> info = ops.entries();
                if (!info.isEmpty()) {
                    dto.setHandleNum(Integer.valueOf(info.get("handleCount")));
                }
            }
            dtos.add(dto);
        }
        pagenationDto.setList(dtos);
        pagenationDto.setTotal(count);
        return pagenationDto;
    }

    @Override
    public OrderConfirmTaskDto selectTaskByTaskId(String taskId,Long merchantId) {
        return BeanUtils.copy(orderConfirmTaskMapper.selectTaskByTaskId(taskId,merchantId),OrderConfirmTaskDto.class);
    }

}
