package com.qiho.center.biz.service.user.impl;

import cn.com.duiba.wolf.utils.BeanUtils;
import cn.com.duiba.wolf.utils.DateUtils;
import com.alibaba.dubbo.common.utils.CollectionUtils;
import com.google.common.collect.Maps;
import com.qiho.center.api.constant.UserOrderConstant;
import com.qiho.center.api.dto.order.WeChatOrderDetailDto;
import com.qiho.center.api.dto.order.WeChatOrderDto;
import com.qiho.center.api.enums.WechatOrderStatusEnum;
import com.qiho.center.biz.service.user.WeChatOrderService;
import com.qiho.center.common.dao.QihoOrderSnapshotDAO;
import com.qiho.center.common.daoh.qiho.UserOrderMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @author: wangjin
 * @create 2018-09-05 13:45
 **/
@Service
public class WeChatOrderServiceImpl implements WeChatOrderService {

    @Autowired
    private UserOrderMapper userOrderMapper;
    @Autowired
    private QihoOrderSnapshotDAO orderSnapshotDAO;


    @Override
    public List<WeChatOrderDto> queryOrderListByUserIdAndStatus(Long userId,List<String> statusList) {

        Map param = Maps.newHashMap();
        param.put("userId",userId);
        param.put("orderSource",UserOrderConstant.WECHAT_SOURCE);
        List<String> ids = userOrderMapper.findOrderIdByUserId(param);
        if (ids.size()>0){
            return transformOrderStatus(
                    BeanUtils.copyList(
                            orderSnapshotDAO.findWeChatOrderByStatus(ids,statusList), WeChatOrderDto.class));
        }
        return Collections.emptyList();
    }

    @Override
    public WeChatOrderDetailDto findOrderByOrderId(String orderId) {
        WeChatOrderDetailDto detailDto = BeanUtils.copy(
                orderSnapshotDAO.findByOrderId(orderId), WeChatOrderDetailDto.class);
        WechatOrderStatusEnum statusEnum = WechatOrderStatusEnum.getByCode(detailDto.getOrderStatus());
        if (statusEnum != null){
            detailDto.setOrderStatusCode(detailDto.getOrderStatus());
            detailDto.setOrderStatus(statusEnum.getDesc());
        } else {
            detailDto.setOrderStatusCode(detailDto.getOrderStatus());
        }

        detailDto.setCreateTime(DateUtils.getSecondStr(detailDto.getGmtCreate()));

        return detailDto;
    }


    private List<WeChatOrderDto> transformOrderStatus(List<WeChatOrderDto> list){

        if (!CollectionUtils.isEmpty(list)) {
            list = list.stream().sorted(Comparator.comparing(WeChatOrderDto::getGmtCreate).reversed()).
                    collect(Collectors.toList());
            list.stream().forEach(item -> {
                WechatOrderStatusEnum statusEnum = WechatOrderStatusEnum.getByCode(item.getOrderStatus());
                if (statusEnum != null) {
                    item.setOrderStatusCode(item.getOrderStatus());
                    item.setOrderStatus(statusEnum.getDesc());
                } else {
                    item.setOrderStatusCode(item.getOrderStatus());
                }
            });
        }
        return list;
    }
}
