package com.qiho.center.biz.service.wechat.impl;

import com.alibaba.fastjson.JSONObject;
import com.qiho.center.api.constant.ConfigConstant;
import com.qiho.center.api.dto.ConfigDto;
import com.qiho.center.api.dto.ResultDto;
import com.qiho.center.api.dto.config.WechatItemConfigDto;
import com.qiho.center.api.params.ConfigParams;
import com.qiho.center.biz.service.ConfigService;
import com.qiho.center.biz.service.wechat.WechatItemService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * @author chensong
 * @create 2018-09-05
 */
@Service
public class WechatItemServiceImpl implements WechatItemService {

    private static final Logger LOGGER = LoggerFactory.getLogger(WechatItemServiceImpl.class);


    @Autowired
    private ConfigService configService;

    @Override
    public WechatItemConfigDto getWechatItemConfig(Long itemId) {

        String configName = ConfigConstant.getWechatItemConfigName(itemId);
        ConfigDto configDto = configService.fetchConfigByName(configName);
        if (configDto == null) {
            return null;
        }

        try{
            return JSONObject.parseObject(configDto.getConfigValue(), WechatItemConfigDto.class);
        } catch (Exception e){
            LOGGER.error("解析微信商品配置异常，itemId={}，data={}", itemId, configDto, e);
            return null;
        }
    }

    @Override
    public ResultDto<Boolean> saveWechatItemConfig(Long itemId, WechatItemConfigDto itemConfig) {

        ConfigParams configParams = new ConfigParams();

        configParams.setConfigName(ConfigConstant.getWechatItemConfigName(itemId));
        configParams.setConfigValue(JSONObject.toJSONString(itemConfig));

        return configService.insertOrUpdateConfig(configParams);
    }


}
