package com.qiho.center.biz.subscribe;

import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import com.google.common.eventbus.Subscribe;
import com.qiho.center.biz.bo.DeliverData2TuiaBo;
import com.qiho.center.biz.event.DeliverData2TuiaEvent;
import com.qiho.center.common.annotations.BizEventListener;
import com.qiho.center.common.dao.QihoChannelInfoDAO;
import com.qiho.center.common.entity.order.QihoChannelInfoEntity;

import cn.com.duiba.wolf.perf.timeprofile.DBTimeProfile;

/**
 * 签收数据回传推啊事件 订阅者
 *
 * @author jiafeng.geng
 * @date 2018-8-30
 */
@Component
@BizEventListener
@Deprecated
public class DeliverData2TuiaSubscribe {

    private static final Logger LOGGER = LoggerFactory.getLogger(DeliverData2TuiaSubscribe.class);

    @Autowired
    private QihoChannelInfoDAO qihoChannelInfoDAO;

    @Autowired
    private DeliverData2TuiaBo deliverData2TuiaBo;

    /**
     * 处理 签收回传推啊异步事件
     *
     * @param event
     */
    @Subscribe
    public void deliverData2TuiaEvent(DeliverData2TuiaEvent event) {
        String orderId = event.getOrderId();
        Integer subType = event.getSubType();

        DBTimeProfile.enter("签收数据回传推啊事件处理, orderId= " + orderId + ", subType=" + subType);

        // 临时排查问题使用info日志
        LOGGER.info("签收数据回传推啊 , order {}",orderId);
        DBTimeProfile.enter("orderId查询渠道信息");
        QihoChannelInfoEntity channelInfoEntity = qihoChannelInfoDAO.findByOrderId(orderId);
        if (null == channelInfoEntity) {
            DBTimeProfile.release();
            DBTimeProfile.release();
            LOGGER.info("根据orderId获取channel对象失败, orderId={}, subType=", orderId, subType);
            return;
        }
        DBTimeProfile.release();

        String url = channelInfoEntity.getUrl();
        String callbackData = null;
        if (StringUtils.isNotBlank(url)) {
            callbackData = deliverData2TuiaBo.deliverData(url, subType);
        }

        if (StringUtils.isBlank(callbackData)) {
            LOGGER.warn("回传推啊失败, orderId={}, url={} subType={}", orderId, url, subType);
        }

        DBTimeProfile.release();
    }
}
