package com.qiho.center.biz.subscribe;

import cn.com.duiba.stock.service.api.remoteservice.RemoteStockBackendService;
import cn.com.duiba.wolf.dubbo.DubboResult;
import cn.com.duiba.wolf.perf.timeprofile.DBTimeProfile;
import com.google.common.eventbus.Subscribe;
import com.qiho.center.api.enums.StockWarnStatusEnum;
import com.qiho.center.biz.event.WarningEvent;
import com.qiho.center.common.annotations.BizEventListener;
import com.qiho.center.common.constant.DingTalkConstants;
import com.qiho.center.common.dao.QihoItemDAO;
import com.qiho.center.common.dao.QihoItemSkuDAO;
import com.qiho.center.common.dao.QihoMerchantDAO;
import com.qiho.center.common.dao.QihoSkuPropertyValueDAO;
import com.qiho.center.common.daoh.qiho.StockWarningMapper;
import com.qiho.center.common.daoh.qihostatistics.SkuDaySaleMapper;
import com.qiho.center.common.entity.item.QihoItemEntity;
import com.qiho.center.common.entity.item.QihoItemSkuEntity;
import com.qiho.center.common.entity.item.QihoSkuPropertyValueEntity;
import com.qiho.center.common.entity.merchant.QihoMerchantEntity;
import com.qiho.center.common.entityd.qiho.StockWarningEntity;
import com.qiho.center.common.entityd.qihostatistics.SkuDaySaleEntity;
import com.qiho.center.common.util.DingTalkUtil;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

/**
 * Created by weny.cai on 2018/1/12.
 */
@Service
@BizEventListener
public class WarningSubscribeService {
    private static final Logger LOGGER = LoggerFactory.getLogger(WarningSubscribeService.class);

    @Resource
    StockWarningMapper stockWarningMapper;

    @Resource
    SkuDaySaleMapper skuDaySaleMapper;

    @Resource
    RemoteStockBackendService remoteStockBackendService;

    @Resource
    QihoSkuPropertyValueDAO qihoSkuPropertyValueDAO;

    @Resource
    QihoItemSkuDAO qihoItemSkuDAO;

    @Resource
    private QihoItemDAO qihoItemDAO;
    @Resource
    private QihoMerchantDAO qihoMerchantDAO;

    /**
     * 库存预警监听处理
     * @author weny.cai
     * @param warningEvent
     */
    @Subscribe
    public void warningHandler(WarningEvent warningEvent){

        // 添加超时打印
        DBTimeProfile.enter("warningHandler");

        QihoItemSkuEntity qihoItemSkuEntity = qihoItemSkuDAO.findById(warningEvent.getSkuId());
        if(qihoItemSkuEntity == null) {
            DBTimeProfile.release();
            return;
        };
        int saleNum = this.getAvgSale(qihoItemSkuEntity.getSkuNo());
        StockWarningEntity param = new StockWarningEntity();

        param.setSkuId(qihoItemSkuEntity.getId());
        param.setItemId(qihoItemSkuEntity.getItemId());
        StockWarningEntity result = stockWarningMapper.selectBySkuIdAndItemId(param);
        if(saleNum==0){
            //删除数据
            if(result != null){
                stockWarningMapper.deleteByPrimaryKey(result.getId());
            }
            DBTimeProfile.release();
            return;
        }
        DubboResult<Long> dubboResult = remoteStockBackendService.find(qihoItemSkuEntity.getStockId());
        String name = getName(qihoItemSkuEntity);

        dbHandler(qihoItemSkuEntity, saleNum, dubboResult, name,result);

        DBTimeProfile.release();

    }

    private void dbHandler(QihoItemSkuEntity qihoItemSkuEntity, int saleNum,
                           DubboResult<Long> dubboResult, String name,StockWarningEntity result) {
        StockWarningEntity stockWarningEntity = new StockWarningEntity();
        stockWarningEntity.setItemId(qihoItemSkuEntity.getItemId());
        stockWarningEntity.setSkuId(qihoItemSkuEntity.getId());
        stockWarningEntity.setSkuName(name);
        stockWarningEntity.setStockNum(dubboResult.getResult().intValue());
        stockWarningEntity.setSuggestNum(7*saleNum);
        stockWarningEntity.setAvgSaleStock(saleNum);

        //预警
        if(dubboResult.getResult()<7*saleNum){
            stockWarningEntity.setWarnStatus(0);
            //缺货
            if(dubboResult.getResult()<=0){
                stockWarningEntity.setWarnStatus(1);
            }
            if(result == null){
                stockWarningMapper.insert(stockWarningEntity);
                //发送钉钉报警
                sendDingTalk(stockWarningEntity);
            }else{
                stockWarningEntity.setId(result.getId());
                stockWarningMapper.updateByPrimaryKeySelective(stockWarningEntity);
            }
        }else {
            if(result != null){
                stockWarningMapper.deleteByPrimaryKey(result.getId());
            }
        }
    }

    /**
     * 发送钉钉报警
     * @param stockWarningEntity 内容
     */
    private void sendDingTalk(StockWarningEntity stockWarningEntity){
        QihoItemEntity itemEntity = qihoItemDAO.findSimpleById(stockWarningEntity.getItemId());
        QihoMerchantEntity merchantEntity = null;
        if (itemEntity != null){
            merchantEntity = qihoMerchantDAO.getByItemId(itemEntity.getId());
        }
        StringBuilder msg = new StringBuilder();
        msg.append("产生一条新的库存预警！！预警内容如下：").append("\n");
        msg.append("商家id：").append(merchantEntity != null?merchantEntity.getId():null).append("，商家名称：").append(merchantEntity != null?merchantEntity.getMerchantName():null).append("\n");
        msg.append("商品id：").append(stockWarningEntity.getItemId()).append("，商品名称：").append(itemEntity != null?itemEntity.getItemName():null).append("\n");
        msg.append("预警状态：").append(StockWarnStatusEnum.getName(stockWarningEntity.getWarnStatus())).append("，预警时间：").append(LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"))).append("\n");
        DingTalkUtil.sendTextMessageWith(String.valueOf(msg), DingTalkConstants.STOCK_WARNNING_DING_TALK_URL,true);
    }

    private String getName(QihoItemSkuEntity qihoItemSkuEntity) {
        String name = "";
        if(StringUtils.isNotBlank(qihoItemSkuEntity.getProperties())){
            String properties = qihoItemSkuEntity.getProperties();
            String[]  p = properties.split(";");
            for (String s : p) {
                String value = s.split(":")[1];
                QihoSkuPropertyValueEntity qihoSkuPropertyValueEntity = qihoSkuPropertyValueDAO.findById(value);
                name = name + qihoSkuPropertyValueEntity.getPropertyValue()+"-";
            }
            if(StringUtils.isNotBlank(name)){
                name = name.substring(0,name.length()-1);
            }
        }
        return name;
    }

    /**
     * 获取平均销售库存
     * 获取七天前的时间
     * @return
     */
    private int getAvgSale(String skuNo){
        Date weekAgoTime = this.getWeekAgoTime();
        SkuDaySaleEntity skuDaySale = new SkuDaySaleEntity();
        skuDaySale.setSaleDate(weekAgoTime);
        skuDaySale.setSkuNo(skuNo);
        List<SkuDaySaleEntity> list = skuDaySaleMapper.selectByDate(skuDaySale);
        if(list.isEmpty()){
            return 0;
        }
        int total = 0 ;
        for (SkuDaySaleEntity daySale : list) {
            total+=daySale.getSaleNum();
        }
        return total%list.size()==0?total/list.size():(total/list.size()+1);
    }

    private Date getWeekAgoTime(){
        Calendar cal = Calendar.getInstance();
        cal.add(Calendar.DATE,-7);
        cal.set(Calendar.HOUR_OF_DAY, 0);//时
        cal.set(Calendar.MINUTE, 0);//分
        cal.set(Calendar.SECOND, 0);//秒
        return cal.getTime();
    }

}
