package com.qiho.center.biz.util;

import cn.com.duiba.boot.exception.BizException;
import com.qiho.center.api.dto.menu.AccountMenuDto;
import com.qiho.center.api.enums.account.BaiqiAccountTypeEnum;
import com.qiho.center.common.entityd.qiho.menu.BaiqiAccountMenuEntity;
import com.qiho.center.common.entityd.qiho.menu.BaiqiMenuEntity;
import org.apache.commons.collections.CollectionUtils;

import java.util.*;

/**
 * 菜单工具类
 *
 * @author zhangshun
 * @version V1.0
 * @since 2017-12-22 15:12
 */
public class AccountMenuUtil {

    private AccountMenuUtil() {
    }

    /**
     * 检查是否商家主账号
     *
     * @param accountType
     * @throws cn.com.duiba.boot.exception.BizException
     */
    public static void checkMasterAccount(int accountType) throws BizException {
        if (!AccountMenuUtil.isMasterAccount(accountType)) {
            throw new BizException("子账号不能操作！");
        }
    }

    /**
     * 判断是商家主账号
     *
     * @param accountType
     * @return
     */
    public static boolean isMasterAccount(int accountType) {
        return BaiqiAccountTypeEnum.MAIN_ACCOUNT.getCode() == accountType;
    }

    /**
     * 判断是商家子账号
     *
     * @param accountType
     * @return
     */
    public static boolean isSubAccount(int accountType) {
        return BaiqiAccountTypeEnum.SUB_ACCOUNT.getCode() == accountType;
    }

    /**
     * 判断是代理账号
     *
     * @param accountType
     * @return
     */
    public static boolean isAgentAccount(int accountType) {
        return BaiqiAccountTypeEnum.AGENT_ACCOUNT.getCode() == accountType;
    }

    /**
     * 转换数据 Entity To Dto
     *
     * @param entity
     * @return
     */
    public static AccountMenuDto convertMenuEntityToDto(BaiqiMenuEntity entity) {
        if (entity == null) {
            return null;
        }
        AccountMenuDto menuDto = new AccountMenuDto();
        menuDto.setId(entity.getId());
        menuDto.setParentId(entity.getParentId());
        menuDto.setMenuCode(entity.getMenuCode());
        menuDto.setMenuName(entity.getMenuName());
        return menuDto;
    }

    /**
     * 转换数据 ListEntity To MapDto
     *
     * @param entityList
     * @return
     */
    public static List<AccountMenuDto> convertMenuEntityToDto(List<BaiqiMenuEntity> entityList) {
        if (null == entityList || entityList.isEmpty()) {
            return Collections.emptyList();
        }
        List<AccountMenuDto> accountMenuDtoList = new ArrayList<>();
        for (BaiqiMenuEntity entity : entityList) {
            accountMenuDtoList.add(convertMenuEntityToDto(entity));
        }
        return accountMenuDtoList;
    }

    /**
     * 转换数据 左边菜单
     *
     * @param entityList
     * @return
     */
    public static List<AccountMenuDto> convertMenuEntityToDto(List<BaiqiMenuEntity> entityList, List<Long> menuIdList) {
        if (CollectionUtils.isEmpty(entityList) || CollectionUtils.isEmpty(menuIdList)) {
            return Collections.emptyList();
        }

        List<AccountMenuDto> accountMenuDtoList = new ArrayList<>();

        AccountMenuDto accountMenuDto = null;
        for (BaiqiMenuEntity entity : entityList) {
            accountMenuDto = convertMenuEntityToDto(entity);
            if (null == accountMenuDto || !menuIdList.contains(accountMenuDto.getId())) {
                continue;
            }
            accountMenuDtoList.add(accountMenuDto);
        }
        return accountMenuDtoList;
    }

    /**
     * 转换数据 ListEntity To MapDto
     *
     * @param entityList
     * @return
     */
    public static Map<Long, AccountMenuDto> convertMenuMapEntityToDto(List<BaiqiMenuEntity> entityList) {
        if (CollectionUtils.isEmpty(entityList)) {
            return Collections.emptyMap();
        }
        Map<Long, AccountMenuDto> accountMenuDtoMap = new LinkedHashMap<>();
        AccountMenuDto accountMenuDto = null;
        for (BaiqiMenuEntity entity : entityList) {
            accountMenuDto = convertMenuEntityToDto(entity);
            if (null == accountMenuDto) {
                continue;
            }
            accountMenuDto.setSelected(false);
            accountMenuDtoMap.put(entity.getId(), accountMenuDto);
        }
        return accountMenuDtoMap;
    }

    public static List<Long> convertMenuEntityToListMenuId(List<BaiqiAccountMenuEntity> accountMenuEntityList) {
        if (CollectionUtils.isEmpty(accountMenuEntityList)) {
            return Collections.emptyList();
        }
        List<Long> menuIdList = new ArrayList<>();
        for (BaiqiAccountMenuEntity accountMenuEntity : accountMenuEntityList) {
            menuIdList.add(accountMenuEntity.getMenuId());
        }
        return menuIdList;
    }

    /**
     * 菜单数据转换 ListDto to Tree
     *
     * @param dataList
     */
    public static List<AccountMenuDto> convertMenuListToTree(List<AccountMenuDto> dataList) {

        // 获取一级菜单
        List<AccountMenuDto> parentList = getByParent(0L, dataList);

        if (parentList.isEmpty()) {
            return Collections.emptyList();
        }

        // 处理二级菜单
        List<AccountMenuDto> subList = null;
        for (AccountMenuDto parentMenu : parentList) {
            subList = getByParent(parentMenu.getId(), dataList);
            if (!CollectionUtils.isEmpty(subList)) {
                parentMenu.setSubMenu(subList);
            }
        }

        return parentList;
    }

    private static List<AccountMenuDto> getByParent(Long parentId, List<AccountMenuDto> dataList) {

        List<AccountMenuDto> result = new ArrayList<>();

        Iterator<AccountMenuDto> iterator = dataList.iterator();
        AccountMenuDto accountMenuDto = null;

        while (iterator.hasNext()) {
            accountMenuDto = iterator.next();
            if (null != accountMenuDto && parentId.equals(accountMenuDto.getParentId())) {
                result.add(accountMenuDto);
                iterator.remove();
            }
        }
        return result;
    }

}
