package com.qiho.center.biz.util;

import java.util.regex.Pattern;

import org.apache.commons.lang3.StringUtils;

/**
 * Created by weny.cai on 2017/8/3.
 */
public class MobileUtil {
    /**
     * 手机号正则
     */
    private static final String PHONE_REG = "^(13[0-9]|14[5-9]|15[0-9]|166|17[0-8]|18[0-9]|19[8,9])[0-9]{8}$";

    private static Pattern phonePattern = Pattern.compile(PHONE_REG);

    private MobileUtil() {
    }

    /**
     * 隐藏手机号码中间6位
     *
     * @param mobile
     * @return
     */
    public static String offSensitive(String mobile) {
        return mobile.substring(0, 3) + "******" + mobile.substring(9);
    }

    /**
     * 验证手机号是否合法
     *
     * @param phoneNum 手机号
     * @return true:合法,false:不合法
     */
    public static boolean validPhoneNum(String phoneNum) {
        if (StringUtils.isBlank(phoneNum)) {
            return Boolean.FALSE;
        }
        return phonePattern.matcher(phoneNum).matches();
    }
}
