/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.client;

import com.rabbitmq.client.SocketChannelConfigurator;
import com.rabbitmq.client.SocketConfigurators;
import java.io.IOException;
import java.nio.channels.SocketChannel;

public abstract class SocketChannelConfigurators {
    public static final AbstractSocketChannelConfigurator DISABLE_NAGLE_ALGORITHM;
    public static final AbstractSocketChannelConfigurator DEFAULT;

    public static AbstractSocketChannelConfigurator defaultConfigurator() {
        return DEFAULT;
    }

    public static AbstractSocketChannelConfigurator disableNagleAlgorithm() {
        return DISABLE_NAGLE_ALGORITHM;
    }

    public static Builder builder() {
        return new Builder();
    }

    static {
        DEFAULT = DISABLE_NAGLE_ALGORITHM = new AbstractSocketChannelConfigurator(){

            @Override
            public void configure(SocketChannel socketChannel) throws IOException {
                SocketConfigurators.DISABLE_NAGLE_ALGORITHM.configure(socketChannel.socket());
            }
        };
    }

    public static class Builder {
        private AbstractSocketChannelConfigurator configurator = new AbstractSocketChannelConfigurator(){

            @Override
            public void configure(SocketChannel channel) {
            }
        };

        public Builder defaultConfigurator() {
            this.configurator = this.configurator.andThen(DEFAULT);
            return this;
        }

        public Builder disableNagleAlgorithm() {
            this.configurator = this.configurator.andThen(DISABLE_NAGLE_ALGORITHM);
            return this;
        }

        public Builder add(SocketChannelConfigurator extraConfiguration) {
            this.configurator = this.configurator.andThen(extraConfiguration);
            return this;
        }

        public SocketChannelConfigurator build() {
            return this.configurator;
        }
    }

    public static abstract class AbstractSocketChannelConfigurator
    implements SocketChannelConfigurator {
        public AbstractSocketChannelConfigurator andThen(final SocketChannelConfigurator after) {
            if (after == null) {
                throw new NullPointerException();
            }
            return new AbstractSocketChannelConfigurator(){

                @Override
                public void configure(SocketChannel socketChannel) throws IOException {
                    AbstractSocketChannelConfigurator.this.configure(socketChannel);
                    after.configure(socketChannel);
                }
            };
        }
    }
}

