/*
 * Decompiled with CFR 0.152.
 */
package com.rome.sign.httpclient;

import com.rome.sign.core.SignConstant;
import com.rome.sign.httpclient.SignExecChain;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.execchain.ClientExecChain;

public class LYFHttpClientBuilder
extends HttpClientBuilder {
    private String clientId;
    private String secret;

    private LYFHttpClientBuilder() {
        String userAgent = String.format("LYF-SHA1-Apache-HttpClient/%s (%s) Java/%s", ((Object)((Object)this)).getClass().getPackage().getImplementationVersion(), SignConstant.OS, SignConstant.VERSION == null ? "Unknown" : SignConstant.VERSION);
        this.setUserAgent(userAgent);
    }

    public LYFHttpClientBuilder clientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    public LYFHttpClientBuilder secret(String secret) {
        this.secret = secret;
        return this;
    }

    public CloseableHttpClient build() {
        if (this.clientId == null || "".equals(this.clientId)) {
            throw new IllegalArgumentException("\u7f3a\u5c11\u5546\u6237\u53f7");
        }
        if (this.secret == null || "".equals(this.secret)) {
            throw new IllegalArgumentException("\u7f3a\u5c11\u5546\u6237\u79d8\u94a5");
        }
        return super.build();
    }

    public static LYFHttpClientBuilder create() {
        return new LYFHttpClientBuilder();
    }

    protected ClientExecChain decorateProtocolExec(ClientExecChain requestExecutor) {
        return new SignExecChain(this.clientId, this.secret, requestExecutor);
    }
}

