/*
 * Decompiled with CFR 0.152.
 */
package com.rome.sign.httpclient;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.rome.sign.core.SignData;
import com.rome.sign.core.util.HashUtil;
import com.rome.sign.core.util.HttpUtil;
import com.rome.sign.core.util.SignCalculatorV1;
import com.rome.sign.httpclient.LYFHttpClientConstant;
import java.io.IOException;
import java.util.regex.Pattern;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpException;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpExecutionAware;
import org.apache.http.client.methods.HttpRequestWrapper;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.entity.BufferedHttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.execchain.ClientExecChain;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignExecChain
implements ClientExecChain {
    private static final Logger log = LoggerFactory.getLogger(SignExecChain.class);
    private static final Pattern LYF_GATEWAY_REG = Pattern.compile("openapi.([a-zA-Z\\d_-]*\\.)?laiyifen.com");
    private final String clientId;
    private final String secret;
    private final ClientExecChain clientExecChain;

    public SignExecChain(String client, String secret, ClientExecChain clientExecChain) {
        this.clientId = client;
        this.secret = secret;
        this.clientExecChain = clientExecChain;
    }

    public CloseableHttpResponse execute(HttpRoute route, HttpRequestWrapper request, HttpClientContext clientContext, HttpExecutionAware execAware) throws IOException, HttpException {
        if (LYFHttpClientConstant.GLOBAL_SIGN || LYF_GATEWAY_REG.matcher(request.getTarget().getHostName()).matches()) {
            return this.executeWithSignature(route, request, clientContext, execAware);
        }
        return this.clientExecChain.execute(route, request, clientContext, execAware);
    }

    private CloseableHttpResponse executeWithSignature(HttpRoute route, HttpRequestWrapper request, HttpClientContext clientContext, HttpExecutionAware execAware) throws HttpException, IOException {
        long timestamp = System.currentTimeMillis();
        SignData signData = new SignData();
        signData.setClientId(this.clientId);
        signData.setSecret(this.secret);
        signData.setTimestamp(timestamp);
        signData.setMethod(request.getMethod().toUpperCase());
        signData.setPath(request.getURI().getRawPath());
        signData.setQueryParams(HttpUtil.queryStringConvertToMap(request.getURI().getRawQuery()));
        signData.setMd5Body(this.md5Entity(request));
        request.addHeader("X-Co-Client", this.clientId);
        request.addHeader("X-Co-Timestamp", timestamp + "");
        request.addHeader("X-Co-Sign", SignCalculatorV1.calculateSign(signData));
        request.addHeader("Content-Type", ContentType.APPLICATION_JSON.getMimeType());
        CloseableHttpResponse response = this.clientExecChain.execute(route, request, clientContext, execAware);
        StatusLine statusLine = response.getStatusLine();
        if (statusLine.getStatusCode() >= 200 && statusLine.getStatusCode() < 300) {
            this.convertToRepeatableResponseEntity(response);
            this.validate(response);
        } else {
            log.error("HTTP\u72b6\u6001\u7801\u5f02\u5e38:[{}]", (Object)statusLine.getStatusCode());
        }
        return response;
    }

    private void validate(CloseableHttpResponse response) throws IOException, HttpException {
        if (response.getEntity().getContentLength() == 0L) {
            throw new HttpException("\u54cd\u5e94\u6570\u636e\u957f\u5ea6\u4e3a0\uff01");
        }
        ObjectMapper objectMapper = new ObjectMapper();
        JsonNode jsonNode = objectMapper.readTree(response.getEntity().getContent());
        JsonNode codeNode = jsonNode.get("code");
        if (codeNode == null) {
            throw new HttpException("\u6d88\u606fcode\u4e3a\u7a7a\uff01");
        }
        if ("200005".equals(codeNode.textValue())) {
            throw new HttpException("\u7b7e\u540d\u6821\u9a8c\u5931\u8d25\uff01");
        }
    }

    protected void convertToRepeatableResponseEntity(CloseableHttpResponse response) throws IOException {
        HttpEntity entity = response.getEntity();
        if (entity != null) {
            response.setEntity((HttpEntity)new BufferedHttpEntity(entity));
        }
    }

    private String md5Entity(HttpRequestWrapper request) throws IOException {
        HttpEntity entity;
        if (request instanceof HttpEntityEnclosingRequest && (entity = ((HttpEntityEnclosingRequest)request).getEntity()) != null) {
            BufferedHttpEntity bufferedHttpEntity = new BufferedHttpEntity(entity);
            long length = entity.getContentLength();
            if (length <= 0L) {
                return null;
            }
            byte[] buffer = new byte[(int)length];
            if ((long)bufferedHttpEntity.getContent().read(buffer) != length) {
                return null;
            }
            ((HttpEntityEnclosingRequest)request).setEntity((HttpEntity)bufferedHttpEntity);
            return HashUtil.md5(buffer);
        }
        return null;
    }
}

