/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.kmonitor;

import com.taobao.kmonitor.KMonitor;
import com.taobao.kmonitor.core.MetricsTags;
import com.taobao.kmonitor.impl.KMonitorFactoryWorker;
import com.taobao.kmonitor.impl.KMonitorImpl;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class KMonitorFactory {
    private static final Log LOG = LogFactory.getLog(KMonitorFactory.class);
    private KMonitorFactoryWorker worker = new KMonitorFactoryWorker();

    private KMonitorFactory() {
    }

    public static KMonitor getKMonitor(String groupName) {
        return KMonitorFactory.getInstance().getWorker().getKMonitor(groupName);
    }

    public static Collection<KMonitorImpl> getKmonitors() {
        return KMonitorFactory.getInstance().getWorker().getKmonitors();
    }

    public static void start() {
        try {
            KMonitorFactory.getInstance().getWorker().start();
        }
        catch (Exception ex) {
            LOG.error((Object)"KMonitorFactory start failed.", (Throwable)ex);
        }
    }

    public static boolean isStarted() {
        return KMonitorFactory.getInstance().getWorker().isStarted();
    }

    public static void stop() {
        try {
            KMonitorFactory.getInstance().getWorker().shutdown();
        }
        catch (Exception ex) {
            LOG.error((Object)"KMonitorFactory start failed.", (Throwable)ex);
        }
    }

    private static KMonitorFactory getInstance() {
        return LazyHolder.INSTANCE;
    }

    private KMonitorFactoryWorker getWorker() {
        return this.worker;
    }

    public static void addGlobalTags(MetricsTags metricsTags) {
        KMonitorFactory.getInstance().getWorker().addGlobalTags(metricsTags);
    }

    public static void delGlobalTags(MetricsTags metricsTags) {
        KMonitorFactory.getInstance().getWorker().delGlobalTags(metricsTags);
    }

    public static void addSystemTags(MetricsTags metricsTags) {
        KMonitorFactory.getInstance().getWorker().addSystemTags(metricsTags);
    }

    public static void delSystemTags(MetricsTags metricsTags) {
        KMonitorFactory.getInstance().getWorker().delSystemTags(metricsTags);
    }

    public static MetricsTags getGlobalTags() {
        return KMonitorFactory.getInstance().getWorker().getGlobalTags();
    }

    public static String getServiceName() {
        return KMonitorFactory.getInstance().getWorker().getServiceName();
    }

    private static class LazyHolder {
        private static final KMonitorFactory INSTANCE = new KMonitorFactory();

        private LazyHolder() {
        }
    }
}

