/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.kmonitor.core;

import com.google.common.collect.Lists;
import com.taobao.kmonitor.core.MetricsInfo;
import com.taobao.kmonitor.core.MetricsRecord;
import com.taobao.kmonitor.core.MetricsRecordBuilder;
import com.taobao.kmonitor.statistic.MetricsStatistic;
import java.util.ArrayList;
import java.util.List;

public class MetricsCollector {
    private MetricsStatistic statistic;
    private List<MetricsRecordBuilder> recordBuilders = Lists.newArrayList();

    public MetricsCollector() {
        this.statistic = new MetricsStatistic();
    }

    public MetricsRecordBuilder addRecord(MetricsInfo info) {
        MetricsRecordBuilder builder = new MetricsRecordBuilder(info);
        this.recordBuilders.add(builder);
        return builder;
    }

    public MetricsRecordBuilder addRecord(String name) {
        return this.addRecord(new MetricsInfo(name, name + " record"));
    }

    public int size() {
        return this.recordBuilders.size();
    }

    void clear() {
        this.recordBuilders.clear();
    }

    public List<MetricsRecord> getRecords() {
        ArrayList recs = Lists.newArrayList();
        for (MetricsRecordBuilder builder : this.recordBuilders) {
            recs.add(builder.getRecord());
        }
        return recs;
    }
}

