/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.kmonitor.core;

import com.google.common.base.Splitter;
import com.google.common.collect.Maps;
import com.taobao.kmonitor.core.MetricsSink;
import com.taobao.kmonitor.exception.KMonitorException;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.configuration.SubsetConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class MetricsConfig
extends SubsetConfiguration {
    static final Log LOG = LogFactory.getLog(MetricsConfig.class);
    static final Pattern INSTANCE_REGEX = Pattern.compile("([^.*]+)\\..+");
    static final Splitter SPLITTER = Splitter.on((char)',').trimResults();

    MetricsConfig(Configuration c, String prefix) {
        super(c, prefix.toLowerCase(Locale.US), ".");
    }

    public static MetricsConfig create(String prefix, Configuration c) {
        return c == null ? null : new MetricsConfig(c, prefix);
    }

    public MetricsConfig subset(String prefix) {
        return new MetricsConfig((Configuration)this, prefix);
    }

    public Object getProperty(String key) {
        Object value = super.getProperty(key);
        if (value == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("poking parent '" + this.getParent().getClass().getSimpleName() + "' for key: " + key));
            }
            return this.getParent().getProperty(key.startsWith("*.") ? key : "*." + key);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("returning '" + value + "' for key: " + key));
        }
        return value;
    }

    Iterable<String> keys() {
        return new Iterable(){

            public Iterator<String> iterator() {
                return MetricsConfig.this.getKeys();
            }
        };
    }

    Map<String, MetricsConfig> getInstanceConfigs(String type) {
        HashMap map = Maps.newHashMap();
        MetricsConfig sub = this.subset(type);
        for (String key : sub.keys()) {
            String instance;
            Matcher matcher = INSTANCE_REGEX.matcher(key);
            if (!matcher.matches() || map.containsKey(instance = matcher.group(1))) continue;
            map.put(instance, sub.subset(instance));
        }
        return map;
    }

    MetricsSink getSink(String name) {
        String clsName = this.getClassName(name);
        if (clsName == null) {
            return null;
        }
        try {
            Class<?> e = Class.forName(clsName, true, this.getSinkLoader());
            MetricsSink plugin = (MetricsSink)e.newInstance();
            plugin.init(name.isEmpty() ? this : this.subset(name));
            return plugin;
        }
        catch (Exception e) {
            throw new KMonitorException(e.getMessage());
        }
    }

    String getClassName(String prefix) {
        String classKey = prefix.isEmpty() ? "class" : prefix + ".class";
        String clsName = this.getString(classKey);
        LOG.debug((Object)clsName);
        return clsName != null && !clsName.isEmpty() ? clsName : null;
    }

    ClassLoader getSinkLoader() {
        return ((Object)((Object)this)).getClass().getClassLoader();
    }

    public void clear() {
        super.clear();
    }

    public String toString() {
        return MetricsConfig.toString((Configuration)this);
    }

    private static String toString(Configuration c) {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(buffer);
        PropertiesConfiguration tmp = new PropertiesConfiguration();
        tmp.copy(c);
        try {
            tmp.save((OutputStream)ps);
        }
        catch (Exception e) {
            throw new KMonitorException(e.getMessage());
        }
        return buffer.toString();
    }
}

