/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.kmonitor.core;

import com.taobao.kmonitor.MetricType;
import com.taobao.kmonitor.core.MetricsCollector;
import com.taobao.kmonitor.core.MetricsFactory;
import com.taobao.kmonitor.core.MetricsRecordBuilder;
import com.taobao.kmonitor.core.MetricsTags;
import com.taobao.kmonitor.metric.Metric;
import com.taobao.kmonitor.metric.MutableMetric;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class MetricsData {
    private final String metricName;
    private final MetricType metricType;
    private final int statisticsType;
    private final Map<MetricsTags, Metric> metricMap = new ConcurrentHashMap<MetricsTags, Metric>();
    private volatile boolean unregister = false;

    public MetricsData(String metricName, MetricType metricType, int statisticsType) {
        this.metricName = metricName;
        this.metricType = metricType;
        this.statisticsType = statisticsType;
    }

    public int getMetricsTagsSize() {
        return this.metricMap.size();
    }

    public synchronized void snapshot(MetricsCollector collector, boolean all) {
        for (MetricsTags tags : this.metricMap.keySet()) {
            MetricsRecordBuilder builder = collector.addRecord(this.metricName);
            builder.addTags(tags);
            builder.setService(tags.getService());
            MutableMetric metric = (MutableMetric)((Object)this.metricMap.get(tags));
            metric.snapshot(builder, all);
        }
    }

    public synchronized Metric getMetric(MetricsTags metricsTags) {
        if (this.unregister) {
            return null;
        }
        Metric metric = this.metricMap.get(metricsTags);
        if (metric == null && (metric = MetricsFactory.createMetric(this.metricName, this.metricType, this.statisticsType)) != null) {
            this.metricMap.put(metricsTags, metric);
        }
        return metric;
    }

    public synchronized void removeMetric(MetricsTags metricsTags) {
        if (!this.unregister && this.metricMap.containsKey(metricsTags)) {
            this.metricMap.remove(metricsTags);
        }
    }

    public MetricType getMetricType() {
        return this.metricType;
    }

    public int getStatisticsType() {
        return this.statisticsType;
    }

    public void unregister() {
        this.unregister = true;
    }
}

