/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.kmonitor.core;

import com.taobao.kmonitor.MetricType;
import com.taobao.kmonitor.metric.CounterMetric;
import com.taobao.kmonitor.metric.GaugeMetric;
import com.taobao.kmonitor.metric.Metric;
import com.taobao.kmonitor.metric.QpsMetric;
import com.taobao.kmonitor.metric.RawMetric;

public class MetricsFactory {
    private static synchronized QpsMetric newQps(String metricName) {
        QpsMetric ret = new QpsMetric(metricName);
        return ret;
    }

    private static synchronized RawMetric newRaw(String metricName) {
        RawMetric metric = new RawMetric(metricName);
        return metric;
    }

    private static synchronized GaugeMetric newGauge(String metricName, int statisticsType) {
        GaugeMetric ret = new GaugeMetric(metricName, statisticsType);
        return ret;
    }

    private static synchronized CounterMetric newCounter(String metricName) {
        CounterMetric ret = new CounterMetric(metricName);
        return ret;
    }

    public static Metric createMetric(String metricName, MetricType metricType) {
        return MetricsFactory.createMetric(metricName, metricType, 0);
    }

    public static Metric createMetric(String metricName, MetricType metricType, int statisticsType) {
        switch (metricType) {
            case COUNTER: {
                return MetricsFactory.newCounter(metricName);
            }
            case GAUGE: {
                return MetricsFactory.newGauge(metricName, statisticsType);
            }
            case QPS: {
                return MetricsFactory.newQps(metricName);
            }
            case RAW: {
                return MetricsFactory.newRaw(metricName);
            }
        }
        return null;
    }
}

