/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.kmonitor.core;

import com.taobao.kmonitor.MetricType;
import com.taobao.kmonitor.PriorityType;
import com.taobao.kmonitor.core.MetricsCollector;
import com.taobao.kmonitor.core.MetricsData;
import com.taobao.kmonitor.core.MetricsPriority;
import com.taobao.kmonitor.core.MetricsTags;
import com.taobao.kmonitor.metric.Metric;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class MetricsManager {
    private final String kMonitorName;
    private Lock lock = new ReentrantLock();
    private MetricsPriority metricsPriority;
    private final Map<String, MetricsData> metricDataMap = new ConcurrentHashMap<String, MetricsData>();

    public MetricsManager(String kMonitorName) {
        this.kMonitorName = kMonitorName;
        this.metricsPriority = new MetricsPriority();
    }

    public Map<String, Integer> getDimensions() {
        HashMap<String, Integer> dimensions = new HashMap<String, Integer>();
        for (String name : this.metricDataMap.keySet()) {
            dimensions.put(name, this.metricDataMap.get(name).getMetricsTagsSize());
        }
        return dimensions;
    }

    public Metric getMetric(String metricName, MetricsTags metricsTags) {
        MetricsData metricsData = this.metricDataMap.get(metricName);
        if (metricsData != null) {
            return metricsData.getMetric(metricsTags);
        }
        return null;
    }

    public void recycle(String metricName, MetricsTags metricsTags) {
        MetricsData metricsData = this.metricDataMap.get(metricName);
        if (metricsData != null) {
            metricsData.removeMetric(metricsTags);
        }
    }

    public void snapshot(List<PriorityType> priorities, MetricsCollector collector, boolean all) {
        for (PriorityType priority : priorities) {
            Collection<String> metrics = this.metricsPriority.getMetricsByPriority(priority);
            if (metrics == null) continue;
            for (String metric : metrics) {
                MetricsData metricsData = this.metricDataMap.get(metric);
                if (metricsData == null) continue;
                metricsData.snapshot(collector, all);
            }
        }
    }

    public boolean register(String metricName, MetricType metricType, int statisticsType) {
        return this.register(metricName, metricType, statisticsType, PriorityType.NORMAL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean register(String metricName, MetricType metricType, int statisticsType, PriorityType priority) {
        MetricsData metricsData;
        Lock lock = this.lock;
        synchronized (lock) {
            metricsData = this.metricDataMap.get(metricName);
            if (metricsData == null) {
                metricsData = new MetricsData(metricName, metricType, statisticsType);
                this.metricDataMap.put(metricName, metricsData);
            }
            this.metricsPriority.addMetricsPriority(metricName, priority);
        }
        return metricsData.getMetricType() == metricType && metricsData.getStatisticsType() == statisticsType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Lock lock = this.lock;
        synchronized (lock) {
            this.metricDataMap.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregister(String metricName) {
        Lock lock = this.lock;
        synchronized (lock) {
            MetricsData metricsData = this.metricDataMap.remove(metricName);
            if (metricsData != null) {
                metricsData.unregister();
            }
            this.metricsPriority.removeMetricsPriority(metricName);
        }
    }
}

