/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.kmonitor.core;

import com.taobao.kmonitor.PriorityType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class MetricsPriority {
    private Lock lock = new ReentrantLock();
    private Map<String, PriorityType> dict = new HashMap<String, PriorityType>();
    private Map<PriorityType, Set<String>> priorityMap = new HashMap<PriorityType, Set<String>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMetricsPriority(String name, PriorityType priority) {
        Lock lock = this.lock;
        synchronized (lock) {
            this.dict.put(name, priority);
            if (!this.priorityMap.containsKey((Object)priority)) {
                this.priorityMap.put(priority, new CopyOnWriteArraySet());
            }
            this.priorityMap.get((Object)priority).add(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMetricsPriority(String name) {
        Lock lock = this.lock;
        synchronized (lock) {
            PriorityType priority = this.dict.remove(name);
            if (priority != null && this.priorityMap.containsKey((Object)priority)) {
                this.priorityMap.get((Object)priority).remove(name);
            }
        }
    }

    public Collection<String> getMetricsByPriority(PriorityType priority) {
        return this.priorityMap.get((Object)priority);
    }

    public static List<PriorityType> tickToPriority(int sec) {
        ArrayList<PriorityType> res = new ArrayList<PriorityType>();
        for (PriorityType type : PriorityType.values()) {
            if (sec % type.value() != 0) continue;
            res.add(type);
        }
        return res;
    }
}

