/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.kmonitor.core;

import com.google.common.collect.Lists;
import com.taobao.kmonitor.core.MetricsInfo;
import com.taobao.kmonitor.core.MetricsRecord;
import com.taobao.kmonitor.core.MetricsTag;
import com.taobao.kmonitor.core.MetricsTags;
import com.taobao.kmonitor.core.MetricsValue;
import java.util.List;

public class MetricsRecordBuilder {
    private long timestamp;
    private MetricsInfo info;
    private List<MetricsValue> metrics;
    private List<MetricsTag> tags;
    private String service;

    public MetricsRecordBuilder() {
    }

    public MetricsRecordBuilder(MetricsInfo info) {
        this.timestamp = System.currentTimeMillis();
        this.info = info;
        this.metrics = Lists.newArrayList();
        this.tags = Lists.newArrayList();
    }

    public MetricsRecordBuilder setService(String service) {
        this.service = service;
        return this;
    }

    public String getService() {
        return this.service;
    }

    public MetricsRecordBuilder addTags(MetricsTags tags) {
        for (MetricsTag tag : tags.getTags()) {
            this.addTag(tag);
        }
        return this;
    }

    public MetricsRecordBuilder addTag(MetricsTag tag) {
        this.tags.add(tag);
        return this;
    }

    public <T> MetricsRecordBuilder addMetric(MetricsInfo metricsInfo, T value) {
        this.metrics.add(new MetricsValue<T>(metricsInfo, value));
        return this;
    }

    public int tagsSize() {
        return this.tags.size();
    }

    public int metricsSize() {
        return this.metrics.size();
    }

    public MetricsRecord getRecord() {
        MetricsRecord record = new MetricsRecord(this.info, this.timestamp, this.tags, this.metrics);
        record.setService(this.service);
        return record;
    }
}

