/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.kmonitor.core;

import com.google.common.collect.Maps;
import com.taobao.kmonitor.PriorityType;
import com.taobao.kmonitor.common.ToolUtils;
import com.taobao.kmonitor.core.MetricsCollector;
import com.taobao.kmonitor.core.MetricsConfig;
import com.taobao.kmonitor.core.MetricsPriority;
import com.taobao.kmonitor.core.MetricsRecord;
import com.taobao.kmonitor.core.MetricsSink;
import com.taobao.kmonitor.core.MetricsSource;
import com.taobao.kmonitor.sink.flume.FlumeSink;
import com.taobao.kmonitor.tool.ToolUtil;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MetricsSystem {
    static final Log LOG = LogFactory.getLog(MetricsSystem.class);
    private MetricsCollector collector;
    private ScheduledExecutorService timer;
    private String prefix;
    private int ticker;
    private int period;
    private int delay;
    private boolean monitoring = false;
    private final Map<String, MetricsSource> allSources;
    private final Map<String, MetricsSink> allSinks;
    private MetricsConfig config;
    private Map<String, MetricsConfig> sinkConfigs;

    public MetricsSystem(String prefix) {
        this.prefix = prefix;
        this.allSources = Maps.newHashMap();
        this.allSinks = Maps.newHashMap();
        this.collector = new MetricsCollector();
        this.ticker = 0;
        this.period = 1000;
        this.delay = 10000;
    }

    public void configure(Configuration c) {
        if (c != null) {
            this.config = MetricsConfig.create(this.prefix, c);
            this.configureSinks();
        } else {
            this.configInternalSink();
            LOG.error((Object)"metric system config is null");
        }
    }

    public void configInternalSink() {
        if (this.config != null) {
            MetricsSink oldSink = this.allSinks.get("flume");
            oldSink.close();
        }
        FlumeSink sink = new FlumeSink();
        sink.init(null);
        this.allSinks.put("flume", sink);
    }

    public void configureSinks() {
        if (this.config != null) {
            this.sinkConfigs = this.config.getInstanceConfigs("sink");
            for (Map.Entry<String, MetricsConfig> entry : this.sinkConfigs.entrySet()) {
                MetricsConfig conf = entry.getValue();
                String clsName = conf.getClassName("");
                if (clsName == null) continue;
                String sinkName = entry.getKey();
                MetricsSink metricsSink = conf.getSink("");
                this.allSinks.put(sinkName, metricsSink);
            }
        }
    }

    public boolean isMonitoring() {
        return this.monitoring;
    }

    public int sourceSize() {
        return this.allSources.size();
    }

    public int sinkSize() {
        return this.allSinks.size();
    }

    private synchronized void startTimer() {
        if (this.timer == null) {
            this.timer = Executors.newSingleThreadScheduledExecutor(ToolUtil.buildNameThreadFactory("client-schedule-" + this.prefix));
            this.timer.scheduleAtFixedRate(new Runnable(){

                @Override
                public void run() {
                    MetricsSystem.this.ticker = MetricsSystem.this.ticker % 60 + 1;
                    List<PriorityType> priorities = MetricsPriority.tickToPriority(MetricsSystem.this.ticker);
                    if (!priorities.isEmpty()) {
                        try {
                            MetricsSystem.this.onTimerEvent(priorities);
                        }
                        catch (Exception e) {
                            LOG.error((Object)ToolUtils.throwableToString(e));
                        }
                    }
                }
            }, this.delay, this.period, TimeUnit.MILLISECONDS);
        }
    }

    private synchronized void onTimerEvent(List<PriorityType> priorities) {
        if (this.allSinks.size() > 0) {
            this.publishMetrics(this.sampleMetrics(priorities), false);
        }
    }

    public synchronized void unregisterSource(String name) {
        if (this.allSources.containsKey(name)) {
            this.allSources.remove(name);
        }
    }

    public synchronized void registerSource(String name, String desc, MetricsSource source) {
        this.allSources.put(name, source);
        LOG.debug((Object)("Registered source " + name));
    }

    private synchronized void publishMetrics(List<MetricsRecord> records, boolean immediate) {
        for (MetricsSink ms : this.allSinks.values()) {
            for (MetricsRecord mr : records) {
                ms.putMetrics(mr);
            }
        }
    }

    private synchronized List<MetricsRecord> sampleMetrics(List<PriorityType> priorities) {
        this.collector.clear();
        for (MetricsSource source : this.allSources.values()) {
            source.getMetrics(priorities, this.collector, true);
        }
        return this.collector.getRecords();
    }

    public void start() {
        if (!this.monitoring) {
            this.startTimer();
            this.monitoring = true;
        }
    }

    public void stop() {
        if (this.monitoring) {
            this.allSinks.clear();
            this.allSources.clear();
            this.timer.shutdown();
            this.monitoring = false;
        }
    }
}

