/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.kmonitor.core;

import com.taobao.kmonitor.common.Pair;
import com.taobao.kmonitor.common.ToolUtils;
import com.taobao.kmonitor.core.MetricsTag;
import com.taobao.kmonitor.impl.KMonitorConfig;
import com.taobao.kmonitor.tool.NetWorkUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class MetricsTags {
    public static final String HOSTNAME = "Hostname";
    private Map<String, String> keyValueMap = new HashMap<String, String>();

    @SafeVarargs
    protected MetricsTags(Pair<String, String> ... tagKVs) {
        for (Pair<String, String> tagKv : tagKVs) {
            this.keyValueMap.put(tagKv.getKey(), tagKv.getValue());
        }
    }

    public void addHostnameTag() {
        if (!this.haveHostname()) {
            this.addTag(HOSTNAME, NetWorkUtil.getCacheLocalHostName());
        }
    }

    public void addTernantTag() {
        String ternantTag = KMonitorConfig.getKMonitorTenantName();
        if (ternantTag != null) {
            this.addTag("kmon_tenant_name", ternantTag);
        }
    }

    public void addServiceTag() {
        String serviceTag = this.getValue("kmon_service_name");
        if (serviceTag == null) {
            serviceTag = KMonitorConfig.getGlobalTags().getService();
            if (serviceTag == null) {
                serviceTag = KMonitorConfig.getKMonitorServiceName();
            }
            this.addTag("kmon_service_name", serviceTag);
        }
    }

    public String getService() {
        return this.getValue("kmon_service_name");
    }

    public String getHostname() {
        return this.getValue(HOSTNAME);
    }

    public MetricsTags addTag(String tagK, String tagV) {
        this.keyValueMap.put(tagK, tagV);
        return this;
    }

    private boolean haveHostname() {
        return this.keyValueMap.containsKey(HOSTNAME) || this.keyValueMap.containsKey(HOSTNAME.toLowerCase()) || this.keyValueMap.containsKey(HOSTNAME.toUpperCase());
    }

    public String getValue(String tag) {
        return this.keyValueMap.get(tag);
    }

    protected MetricsTags(Map<String, String> tagKVs) {
        if (ToolUtils.isMapEmpty(tagKVs)) {
            return;
        }
        this.keyValueMap.putAll(tagKVs);
    }

    public Map<String, String> getUnmodifiableTags() {
        return Collections.unmodifiableMap(this.keyValueMap);
    }

    public int size() {
        return this.keyValueMap.size();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MetricsTags)) {
            return false;
        }
        MetricsTags otherTags = (MetricsTags)o;
        return this.keyValueMap.equals(otherTags.getUnmodifiableTags());
    }

    public int hashCode() {
        return this.keyValueMap.hashCode();
    }

    public String toString() {
        return this.keyValueMap.toString();
    }

    public List<MetricsTag> getTags() {
        ArrayList<MetricsTag> tags = new ArrayList<MetricsTag>();
        for (String key : this.keyValueMap.keySet()) {
            tags.add(new MetricsTag(key, this.keyValueMap.get(key)));
        }
        return tags;
    }
}

