/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.kmonitor.example;

import com.taobao.kmonitor.ImmutableMetricTags;
import com.taobao.kmonitor.KMonitor;
import com.taobao.kmonitor.KMonitorFactory;
import com.taobao.kmonitor.MetricType;
import com.taobao.kmonitor.PriorityType;
import com.taobao.kmonitor.impl.KMonitorConfig;

public class Demo {
    private static String TEST_METRIC = "kmonitor.without.hadoop";
    private static String TEST_METRIC_PERFORMANCE_QPS = "kmonitor.performance.qps";
    private static String TEST_METRIC_PERFORMANCE_COUNT = "count.test";
    private static String TEST_PRIORITY_METRIC = "kmonitor.with.priority";
    private static String TEST_GAUGE_METRIC = "kmonitor.gauge.test";

    public static void main(String[] args) throws InterruptedException {
        KMonitorConfig.setKMonitorServiceName("client_service");
        KMonitorConfig.setKMonitorTenantName("default");
        KMonitorConfig.enableSystemMetrics();
        KMonitorConfig.setSystemMetricsReportPeriod(10);
        KMonitorConfig.setSinkAddress("10.101.72.48:4141");
        KMonitor kMonitor = KMonitorFactory.getKMonitor("example");
        KMonitorFactory.start();
        kMonitor.register(TEST_METRIC, MetricType.QPS);
        kMonitor.register(TEST_METRIC_PERFORMANCE_COUNT, MetricType.COUNTER);
        kMonitor.register(TEST_METRIC_PERFORMANCE_QPS, MetricType.QPS);
        kMonitor.register(TEST_PRIORITY_METRIC, MetricType.QPS, PriorityType.CRITICAL);
        kMonitor.register(TEST_GAUGE_METRIC, MetricType.GAUGE, 126);
        KMonitorFactory.addGlobalTags(new ImmutableMetricTags("k", "v", "kmon_service_name", "global_service"));
        KMonitorFactory.addSystemTags(new ImmutableMetricTags("ks", "vs"));
        int tick = 1;
        while (true) {
            kMonitor.report(TEST_GAUGE_METRIC, 1.0);
            if (tick++ % 100 == 0) {
                KMonitorFactory.delGlobalTags(new ImmutableMetricTags("k", "v"));
            }
            Thread.sleep(1000L);
        }
    }
}

