/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.kmonitor.impl;

import com.taobao.kmonitor.ImmutableMetricTags;
import com.taobao.kmonitor.PriorityType;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.MapConfiguration;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.configuration.SubsetConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class KMonitorConfig {
    private static final Log LOG = LogFactory.getLog(KMonitorConfig.class);
    public static final String KMONITOR_METRICS_SYSTEM_NAME = "kmonitor";
    public static final String KMONITOR_CONFIG_FILENAME = "kmonitor.properties";
    public static final String KMONITOR_SERVICE_TAG = "kmon_service_name";
    public static final String KMONITOR_TENANT_TAG = "kmon_tenant_name";
    private static final String KMONITOR_CONFIG_PREFIX = "kmonitor";
    private static final String KMONITOR_TENANT_NAME = "tenant.name";
    private static final String KMONITOR_SERVICE_NAME = "service.name";
    private static final String KMONITOR_GLOBAL_TAGS = "metrics.global.tags";
    private static final String KMONITOR_DEBUG_OPEN = "debug.open";
    private static final String SYSTEM_METRICS_ENABLE = "system.metrics.enable";
    private static final boolean DEFAULT_SYSTEM_METRICS_ENABLE = true;
    private static final String SYSTEM_METRICS_REPORT_PERIOD = "system.metrics.report.period";
    private static final long DEFAULT_SYSTEM_METRICS_REPORT_PERIOD = 15L;
    private static final String SYSTEM_ALIMONITOR_CPU_ENABLE = "system.alimonitor.cpu.enbale";
    private static final String SYSTEM_ALIMONITOR_MEM_ENABLE = "system.alimonitor.mem.enbale";
    private static final String SYSTEM_ALIMONITOR_DISK_ENABLE = "system.alimonitor.disk.enbale";
    private static final String SYSTEM_ALIMONITOR_NET_ENABLE = "system.alimonitor.net.enbale";
    private static final String SYSTEM_ALIMONITOR_LOAD_ENABLE = "system.alimonitor.load.enbale";
    private static final String FLUME_SINK_FREQUENCY = "sink.flume.frequency";
    private static PropertiesConfiguration fileConfig = new PropertiesConfiguration();
    private static SubsetConfiguration kMonitorConfig;
    private static String serviceName;
    private static String tenantName;
    private static ImmutableMetricTags globalTag;
    private static boolean fileInited;
    private static boolean debuged;
    private static boolean systemMetricsEnabled;
    private static long systemMetricsPeriod;
    private static String sinkAddress;
    private static boolean systemAlimonitorCpuEnabled;
    private static boolean systemAlimonitorMemEnabled;
    private static boolean systemAlimonitorDiskEnabled;
    private static boolean systemAlimonitorNetEnabled;
    private static boolean systemAlimonitorLoadEnabled;
    private static String defaultSinkFrequency;

    public static boolean isFileInited() {
        return fileInited;
    }

    public static void init() {
        try {
            fileConfig = new PropertiesConfiguration(KMONITOR_CONFIG_FILENAME);
            kMonitorConfig = new SubsetConfiguration((Configuration)fileConfig, "kmonitor", ".");
            KMonitorConfig.getKMonitorServiceName();
            KMonitorConfig.getKMonitorTenantName();
            fileInited = true;
            LOG.info((Object)("loaded " + fileConfig.getFileName() + " success"));
        }
        catch (Exception e) {
            fileConfig = null;
            LOG.warn((Object)"cannot locate kmonitor.properties,maybe you want to init config by yourself?");
            return;
        }
    }

    public static Configuration configuration() {
        return fileConfig != null ? fileConfig.interpolatedConfiguration() : null;
    }

    public static void setSinkAddress(String address) {
        sinkAddress = address;
    }

    public static String getSinkAddress() {
        return sinkAddress;
    }

    public static void addSink(String sinkName, Map<String, String> sinkConfMap) {
        HashMap<String, String> sinkMap = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : sinkConfMap.entrySet()) {
            sinkMap.put("." + entry.getKey(), entry.getValue());
        }
        MapConfiguration sinkMapConfig = new MapConfiguration(sinkMap);
        SubsetConfiguration sinkSubsetConfig = new SubsetConfiguration((Configuration)sinkMapConfig, "", ".");
        SubsetConfiguration kmonitorSinksConfig = new SubsetConfiguration((Configuration)kMonitorConfig, "sink", ".");
        SubsetConfiguration kmonitorSinkConfig = new SubsetConfiguration((Configuration)kmonitorSinksConfig, sinkName, ".");
        kmonitorSinkConfig.copy((Configuration)sinkSubsetConfig);
    }

    public static void setKMonitorServiceName(String name) {
        serviceName = name;
    }

    public static String getKMonitorServiceName() {
        if (serviceName == null) {
            serviceName = kMonitorConfig.getString(KMONITOR_SERVICE_NAME);
        }
        return serviceName;
    }

    public static void setKMonitorTenantName(String name) {
        tenantName = name;
    }

    public static String getKMonitorTenantName() {
        if (tenantName == null) {
            tenantName = kMonitorConfig.getString(KMONITOR_TENANT_NAME);
        }
        return tenantName;
    }

    public static void openDebug() {
        debuged = true;
    }

    public static boolean debugOpen() {
        return debuged || kMonitorConfig.getBoolean(KMONITOR_DEBUG_OPEN);
    }

    public static ImmutableMetricTags getGlobalTags() {
        if (globalTag == null) {
            String[] globalTags;
            try {
                globalTags = kMonitorConfig.getStringArray(KMONITOR_GLOBAL_TAGS);
            }
            catch (Exception ex) {
                LOG.warn((Object)"failed to get global tags, use empty tags instead");
                globalTag = ImmutableMetricTags.EMPTY_METRIC_TAGS;
                return globalTag;
            }
            if (globalTags.length == 0) {
                LOG.info((Object)"empty global tags in config");
                globalTag = ImmutableMetricTags.EMPTY_METRIC_TAGS;
            }
            HashMap<String, String> tagKVs = new HashMap<String, String>();
            for (String tag : globalTags) {
                String[] kv = tag.split(":");
                if (kv.length != 2) {
                    LOG.warn((Object)("invalid global tag: " + tag));
                    continue;
                }
                String key = kv[0].trim();
                String value = kv[1].trim();
                if (key.isEmpty() || value.isEmpty()) {
                    LOG.warn((Object)("invalid global tag, key/value should not be empty: " + tag));
                    continue;
                }
                LOG.info((Object)("add global tag from config, " + key + "=" + value));
                tagKVs.put(kv[0].trim(), kv[1].trim());
            }
            globalTag = new ImmutableMetricTags(tagKVs);
        }
        return globalTag;
    }

    public static void enableSystemMetrics() {
        systemMetricsEnabled = true;
    }

    public static boolean getConfigValue(String key, boolean defaultValue) {
        return kMonitorConfig == null ? false : kMonitorConfig.getBoolean(key, defaultValue);
    }

    public static long getConfigValue(String key, long defaultValue) {
        return kMonitorConfig == null ? defaultValue : kMonitorConfig.getLong(key, defaultValue);
    }

    public static String getConfigValue(String key, String defaultValue) {
        return kMonitorConfig == null ? defaultValue : kMonitorConfig.getString(key, defaultValue);
    }

    public static PriorityType defaultPriorityType() {
        return PriorityType.getPriorityTypeByName(KMonitorConfig.getConfigValue(FLUME_SINK_FREQUENCY, defaultSinkFrequency));
    }

    public static boolean isSystemMetricsEnabled() {
        return systemMetricsEnabled || KMonitorConfig.getConfigValue(SYSTEM_METRICS_ENABLE, true);
    }

    public static boolean isSystemAlimonitorCpuEnabled() {
        return systemAlimonitorCpuEnabled || KMonitorConfig.getConfigValue(SYSTEM_ALIMONITOR_CPU_ENABLE, false);
    }

    public static boolean isSystemAlimonitorDiskEnabled() {
        return systemAlimonitorDiskEnabled || KMonitorConfig.getConfigValue(SYSTEM_ALIMONITOR_DISK_ENABLE, false);
    }

    public static boolean isSystemAlimonitorLoadEnabled() {
        return systemAlimonitorLoadEnabled || KMonitorConfig.getConfigValue(SYSTEM_ALIMONITOR_LOAD_ENABLE, false);
    }

    public static boolean isSystemAlimonitorMemEnabled() {
        return systemAlimonitorMemEnabled || KMonitorConfig.getConfigValue(SYSTEM_ALIMONITOR_MEM_ENABLE, false);
    }

    public static boolean isSystemAlimonitorNetEnabled() {
        return systemAlimonitorNetEnabled || KMonitorConfig.getConfigValue(SYSTEM_ALIMONITOR_NET_ENABLE, false);
    }

    public static void setSystemAlimonitorCpuEnabled(boolean systemAlimonitorCpuEnabled) {
        KMonitorConfig.systemAlimonitorCpuEnabled = systemAlimonitorCpuEnabled;
    }

    public static void setSystemAlimonitorDiskEnabled(boolean systemAlimonitorDiskEnabled) {
        KMonitorConfig.systemAlimonitorDiskEnabled = systemAlimonitorDiskEnabled;
    }

    public static void setSystemAlimonitorNetEnabled(boolean systemAlimonitorNetEnabled) {
        KMonitorConfig.systemAlimonitorNetEnabled = systemAlimonitorNetEnabled;
    }

    public static void setSystemAlimonitorLoadEnabled(boolean systemAlimonitorLoadEnabled) {
        KMonitorConfig.systemAlimonitorLoadEnabled = systemAlimonitorLoadEnabled;
    }

    public static void setSystemAlimonitorMemEnabled(boolean systemAlimonitorMemEnabled) {
        KMonitorConfig.systemAlimonitorMemEnabled = systemAlimonitorMemEnabled;
    }

    public static void setSystemMetricsReportPeriod(int n) {
        systemMetricsPeriod = n;
    }

    public static long getSystemMetricsReportPeriod() {
        long period = systemMetricsPeriod != 0L ? systemMetricsPeriod : KMonitorConfig.getConfigValue(SYSTEM_METRICS_REPORT_PERIOD, 15L);
        LOG.info((Object)("system metrics report period: " + period + "s"));
        return period;
    }

    static {
        serviceName = null;
        tenantName = null;
        globalTag = null;
        fileInited = false;
        debuged = false;
        systemMetricsEnabled = false;
        systemMetricsPeriod = 0L;
        sinkAddress = "localhost:4141";
        systemAlimonitorCpuEnabled = false;
        systemAlimonitorMemEnabled = false;
        systemAlimonitorDiskEnabled = false;
        systemAlimonitorNetEnabled = false;
        systemAlimonitorLoadEnabled = false;
        defaultSinkFrequency = "NORMAL";
        KMonitorConfig.init();
    }
}

