/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.kmonitor.impl;

import com.taobao.kmonitor.ImmutableMetricTags;
import com.taobao.kmonitor.KMonitor;
import com.taobao.kmonitor.core.MetricsSystem;
import com.taobao.kmonitor.core.MetricsTags;
import com.taobao.kmonitor.impl.KMonitorConfig;
import com.taobao.kmonitor.impl.KMonitorImpl;
import com.taobao.kmonitor.system.SystemMetricsManager;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class KMonitorFactoryWorker {
    private static final Log LOG = LogFactory.getLog(KMonitorFactoryWorker.class);
    private volatile boolean started = false;
    private volatile boolean configSuccess = false;
    private String serviceName = KMonitorConfig.getKMonitorServiceName();
    private ImmutableMetricTags globalTags = KMonitorConfig.getGlobalTags();
    private SystemMetricsManager systemMetricsManager;
    private MetricsSystem metricsSystem;
    private final Map<String, KMonitorImpl> kMonitorMap = new ConcurrentHashMap<String, KMonitorImpl>();

    public synchronized void start() {
        if (this.started) {
            return;
        }
        this.metricsSystem = new MetricsSystem("kmonitor");
        this.metricsSystem.configure(KMonitorConfig.configuration());
        this.startKMonitorMetricsSystem();
        this.started = true;
    }

    public boolean isStarted() {
        return this.started;
    }

    private synchronized void startKMonitorMetricsSystem() {
        this.metricsSystem.start();
        if (StringUtils.isEmpty((String)this.serviceName)) {
            LOG.error((Object)"service name is not set or empty. kmonitor will be disabled!");
            this.configSuccess = false;
            return;
        }
        this.configSuccess = true;
        for (KMonitorImpl kMonitor : this.kMonitorMap.values()) {
            this.metricsSystem.registerSource(kMonitor.getkMonitorName(), kMonitor.getkMonitorName() + " metrics source", kMonitor);
        }
        this.systemMetricsManager = new SystemMetricsManager(KMonitorConfig.isSystemMetricsEnabled());
        this.systemMetricsManager.initCollectors();
        this.systemMetricsManager.startReport(KMonitorConfig.getSystemMetricsReportPeriod());
    }

    public synchronized void shutdown() {
        LOG.info((Object)"kMonitor factory worker shutdown.");
        if (this.systemMetricsManager != null) {
            this.systemMetricsManager.stopReport();
        }
        if (this.metricsSystem != null) {
            this.metricsSystem.stop();
        }
        for (KMonitorImpl kMonitor : this.kMonitorMap.values()) {
            kMonitor.stop();
        }
        this.kMonitorMap.clear();
        this.started = false;
        this.configSuccess = false;
    }

    public int kmonitorSize() {
        return this.kMonitorMap.size();
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public Collection<KMonitorImpl> getKmonitors() {
        return this.kMonitorMap.values();
    }

    public synchronized KMonitor getKMonitor(String kMonitorName) {
        KMonitorImpl kMonitor = this.kMonitorMap.get(kMonitorName);
        if (kMonitor == null) {
            kMonitor = new KMonitorImpl(kMonitorName);
            this.kMonitorMap.put(kMonitorName, kMonitor);
            if (this.configSuccess && this.metricsSystem != null) {
                this.metricsSystem.registerSource(kMonitorName, kMonitorName + " metrics source", kMonitor);
            }
        }
        return kMonitor;
    }

    public synchronized void addSystemTags(MetricsTags metricsTags) {
        if (KMonitorConfig.isSystemMetricsEnabled()) {
            this.systemMetricsManager.addMetricsTags(metricsTags);
        }
    }

    public synchronized void delSystemTags(MetricsTags metricsTags) {
        if (KMonitorConfig.isSystemMetricsEnabled()) {
            this.systemMetricsManager.delMetricsTags(metricsTags);
        }
    }

    public synchronized void addGlobalTags(MetricsTags metricsTags) {
        this.globalTags = ImmutableMetricTags.mergeMetricsTags(this.globalTags, metricsTags);
    }

    public synchronized void delGlobalTags(MetricsTags metricsTags) {
        this.globalTags = ImmutableMetricTags.removeMetricTags(this.globalTags, metricsTags);
    }

    public synchronized void addSink(String sinkName, Map<String, String> sinkConfMap) {
        if (this.started) {
            return;
        }
        KMonitorConfig.addSink(sinkName, sinkConfMap);
    }

    public ImmutableMetricTags getGlobalTags() {
        return this.globalTags;
    }
}

