/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.kmonitor.impl;

import com.taobao.kmonitor.ImmutableMetricTags;
import com.taobao.kmonitor.KMonitor;
import com.taobao.kmonitor.KMonitorFactory;
import com.taobao.kmonitor.MetricType;
import com.taobao.kmonitor.PriorityType;
import com.taobao.kmonitor.core.MetricsCollector;
import com.taobao.kmonitor.core.MetricsManager;
import com.taobao.kmonitor.core.MetricsTags;
import com.taobao.kmonitor.impl.KMonitorConfig;
import com.taobao.kmonitor.metric.Metric;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class KMonitorImpl
implements KMonitor {
    private static final Log LOG = LogFactory.getLog(KMonitorImpl.class);
    private MetricsManager metricsManager;
    private String kMonitorName;

    public KMonitorImpl(String kMonitorName) {
        this.kMonitorName = kMonitorName;
        this.metricsManager = new MetricsManager(kMonitorName);
    }

    public Map<String, Integer> getDimensions() {
        return this.metricsManager.getDimensions();
    }

    @Override
    public String name() {
        return this.kMonitorName;
    }

    @Override
    public void getMetrics(List<PriorityType> priorities, MetricsCollector collector, boolean all) {
        this.metricsManager.snapshot(priorities, collector, all);
    }

    private MetricsTags handleMetricsTags(MetricsTags metricsTags) {
        if (metricsTags == null || metricsTags.size() == 0) {
            metricsTags = ImmutableMetricTags.EMPTY_METRIC_TAGS;
        }
        metricsTags.addHostnameTag();
        metricsTags.addServiceTag();
        metricsTags.addTernantTag();
        return ImmutableMetricTags.mergeMetricsTags(metricsTags, KMonitorFactory.getGlobalTags());
    }

    public String getkMonitorName() {
        return this.kMonitorName;
    }

    @Override
    public boolean register(String metricName, MetricType metricType) {
        return this.register(metricName, metricType, 0);
    }

    @Override
    public boolean register(String metricName, MetricType metricType, PriorityType priorityType) {
        return this.register(metricName, metricType, 0, priorityType);
    }

    @Override
    public boolean register(String metricName, MetricType metricType, int statisticsType) {
        return this.register(metricName, metricType, statisticsType, KMonitorConfig.defaultPriorityType());
    }

    @Override
    public boolean register(String metricName, MetricType metricType, int statisticsType, PriorityType priorityType) {
        if (StringUtils.isEmpty((String)metricName) || metricType == null) {
            return false;
        }
        return this.metricsManager.register(this.fullMetricName(metricName), metricType, statisticsType, priorityType);
    }

    @Override
    public void report(String metricName, double value) {
        this.report(metricName, null, value);
    }

    @Override
    public void report(String metricName, MetricsTags metricsTags, double value) {
        if (StringUtils.isEmpty((String)metricName)) {
            return;
        }
        MetricsTags tags = this.handleMetricsTags(metricsTags);
        Metric metric = this.metricsManager.getMetric(this.fullMetricName(metricName), tags);
        if (metric != null) {
            metric.update(value);
        }
    }

    @Override
    public void recycle(String metricName, MetricsTags metricsTags) {
        this.metricsManager.recycle(this.fullMetricName(metricName), this.handleMetricsTags(metricsTags));
    }

    private String fullMetricName(String metricName) {
        return KMonitorConfig.getKMonitorServiceName() + "." + metricName;
    }

    public void stop() {
        this.metricsManager.clear();
    }

    @Override
    public void unregister(String metricName) {
        this.metricsManager.unregister(this.fullMetricName(metricName));
    }
}

