/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.kmonitor.metric;

import com.taobao.kmonitor.StatisticsType;
import com.taobao.kmonitor.core.MetricsInfo;
import com.taobao.kmonitor.core.MetricsRecordBuilder;
import com.taobao.kmonitor.metric.Metric;
import com.taobao.kmonitor.metric.MutableMetric;
import com.taobao.kmonitor.metric.lib.ExponentiallyDecayingSample;
import com.taobao.kmonitor.metric.lib.MinMax;
import com.taobao.kmonitor.metric.lib.Snapshot;

public class GaugeMetric
extends MutableMetric
implements Metric {
    private final MetricsInfo info;
    private final MetricsInfo minInfo;
    private final MetricsInfo maxInfo;
    private final MetricsInfo percentile75Info;
    private final MetricsInfo percentile95Info;
    private final MetricsInfo percentile99Info;
    private final MetricsInfo sumInfo;
    private volatile double sum;
    private volatile int count;
    private final int statisticsType;
    private final MinMax minMax;
    private final ExponentiallyDecayingSample percentileSample;

    public GaugeMetric(String metricName, int statisticsType) {
        this.info = new MetricsInfo(metricName, "interval average for " + metricName);
        this.minInfo = new MetricsInfo(metricName + ".min", "interval min for " + metricName);
        this.maxInfo = new MetricsInfo(metricName + ".max", "interval max for " + metricName);
        this.percentile75Info = new MetricsInfo(metricName + ".p75", "75 percentile for " + metricName);
        this.percentile95Info = new MetricsInfo(metricName + ".p95", "95 percentile for " + metricName);
        this.percentile99Info = new MetricsInfo(metricName + ".p99", "99 percentile for " + metricName);
        this.sumInfo = new MetricsInfo(metricName + ".sum", "interval sum for " + metricName);
        this.sum = 0.0;
        this.count = 0;
        this.statisticsType = statisticsType;
        this.minMax = StatisticsType.needMaxMin(statisticsType) ? new MinMax() : null;
        this.percentileSample = StatisticsType.needPercentile(statisticsType) ? new ExponentiallyDecayingSample() : null;
        this.clearChanged();
    }

    @Override
    public synchronized void update(double value) {
        this.sum += value;
        ++this.count;
        if (this.minMax != null) {
            this.minMax.add(value);
        }
        if (this.percentileSample != null) {
            this.percentileSample.update((long)value);
        }
        this.setChanged();
    }

    @Override
    public synchronized void snapshot(MetricsRecordBuilder builder, boolean all) {
        if (all || this.changed()) {
            if (this.count == 0) {
                return;
            }
            builder.addMetric(this.info, this.sum / (double)this.count);
            if (this.minMax != null) {
                if ((this.statisticsType & 2) > 0) {
                    builder.addMetric(this.minInfo, this.minMax.min());
                }
                if ((this.statisticsType & 4) > 0) {
                    builder.addMetric(this.maxInfo, this.minMax.max());
                }
                this.minMax.reset();
            }
            if (this.percentileSample != null) {
                Snapshot s = this.percentileSample.getSnapshot();
                if ((this.statisticsType & 8) > 0) {
                    builder.addMetric(this.percentile75Info, s.get75thPercentile());
                }
                if ((this.statisticsType & 0x10) > 0) {
                    builder.addMetric(this.percentile95Info, s.get95thPercentile());
                }
                if ((this.statisticsType & 0x20) > 0) {
                    builder.addMetric(this.percentile99Info, s.get99thPercentile());
                }
            }
            if (StatisticsType.needSum(this.statisticsType)) {
                builder.addMetric(this.sumInfo, this.sum);
            }
            this.sum = 0.0;
            this.count = 0;
            this.clearChanged();
        }
    }
}

