/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.kmonitor.metric;

import com.taobao.kmonitor.common.SystemUtils;
import com.taobao.kmonitor.core.MetricsInfo;
import com.taobao.kmonitor.core.MetricsRecordBuilder;
import com.taobao.kmonitor.metric.Metric;
import com.taobao.kmonitor.metric.MutableMetric;

public class QpsMetric
extends MutableMetric
implements Metric {
    private final MetricsInfo info;
    private volatile double value;
    private long lastSampleTime;

    public QpsMetric(String metricName) {
        this.info = new MetricsInfo(metricName, metricName);
        this.value = 0.0;
        this.lastSampleTime = SystemUtils.now();
        this.clearChanged();
    }

    @Override
    public synchronized void update(double value) {
        this.value += value;
        this.setChanged();
    }

    @Override
    public synchronized void snapshot(MetricsRecordBuilder builder, boolean all) {
        if (all || this.changed()) {
            long sampleTime = SystemUtils.now();
            long diff = sampleTime - this.lastSampleTime;
            if (diff <= 0L) {
                return;
            }
            builder.addMetric(this.info, this.value / (double)diff * 1000.0);
            this.value = 0.0;
            this.lastSampleTime = sampleTime;
            this.clearChanged();
        }
    }
}

