/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.kmonitor.net;

import com.google.common.base.Charsets;
import com.taobao.kmonitor.common.ToolUtils;
import com.taobao.kmonitor.net.AgentClient;
import com.taobao.kmonitor.tool.NetWorkUtil;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AgentIp {
    private static final Logger log = LoggerFactory.getLogger(AgentClient.class);
    private static final String DEFAULT_HOST_PATH = "/etc/hostinfo";

    public static String getIp(String filePath) {
        Path path = Paths.get(filePath, new String[0]);
        String ip = "";
        if (Files.exists(path, new LinkOption[0])) {
            try {
                List<String> lines = Files.readAllLines(path, Charsets.UTF_8);
                for (String s : lines) {
                    if (!NetWorkUtil.isIpv4(s)) continue;
                    ip = s;
                }
            }
            catch (IOException e) {
                log.error(ToolUtils.throwableToString(e));
            }
        }
        return ip;
    }

    public static String getIp() {
        return AgentIp.getIp(DEFAULT_HOST_PATH);
    }
}

