/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.kmonitor.statistic;

import com.taobao.kmonitor.KMonitorFactory;
import com.taobao.kmonitor.common.SystemUtils;
import com.taobao.kmonitor.common.ToolUtils;
import com.taobao.kmonitor.core.MetricsInfo;
import com.taobao.kmonitor.core.MetricsRecord;
import com.taobao.kmonitor.core.MetricsValue;
import com.taobao.kmonitor.impl.KMonitorImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class MetricsStatistic {
    private static final String METRICS_STATISTIC = "kmstatistic";
    private static final String METRICS_TOTAL_DIMENSIONS = "total";
    private static final String METRICS_DIMENSION = "dimension";
    private volatile MetricsInfo info = new MetricsInfo("kmstatistic", "kmstatistic");

    public void record(List<MetricsRecord> records) {
        ArrayList<MetricsValue> values = new ArrayList<MetricsValue>();
        int total = 0;
        for (KMonitorImpl kMonitor : KMonitorFactory.getKmonitors()) {
            Map<String, Integer> dimensions = kMonitor.getDimensions();
            for (String name : dimensions.keySet()) {
                String newName = ToolUtils.buildMetricName(METRICS_STATISTIC, KMonitorFactory.getServiceName(), kMonitor.getkMonitorName(), name, METRICS_DIMENSION);
                int number = dimensions.get(name);
                MetricsValue<Integer> value = new MetricsValue<Integer>(newName, Integer.valueOf(number));
                values.add(value);
                total += number;
            }
        }
        MetricsValue<Integer> totalValue = new MetricsValue<Integer>(ToolUtils.buildMetricName(METRICS_STATISTIC, KMonitorFactory.getServiceName(), METRICS_TOTAL_DIMENSIONS, METRICS_DIMENSION), Integer.valueOf(total));
        values.add(totalValue);
        MetricsRecord record = new MetricsRecord(this.info, SystemUtils.now(), KMonitorFactory.getGlobalTags().getTags(), values);
        records.add(record);
    }
}

