/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.kmonitor.system;

import com.taobao.kmonitor.ImmutableMetricTags;
import com.taobao.kmonitor.KMonitor;
import com.taobao.kmonitor.KMonitorFactory;
import com.taobao.kmonitor.MetricType;
import com.taobao.kmonitor.impl.KMonitorConfig;
import com.taobao.kmonitor.system.Collector;
import com.taobao.kmonitor.system.alimonitor.Tsar;
import com.taobao.kmonitor.system.alimonitor.TsarResult;
import com.taobao.kmonitor.tool.EnvUtil;
import com.taobao.kmonitor.tool.FileUtil;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AlimonitorCollector
implements Collector {
    private static final Log LOG = LogFactory.getLog(AlimonitorCollector.class);
    protected static final String SYSTEM_CPU = "system.cpu";
    protected static final String SYSTEM_LOAD1 = "system.load1";
    protected static final String SYSTEM_LOAD5 = "system.load5";
    protected static final String SYSTEM_LOAD15 = "system.load15";
    protected static final String SYSTEM_MEM = "system.mem";
    protected static final String SYSTEM_MEM_USED = "system.mem.used";
    protected static final String SYSTEM_MEM_FREE = "system.mem.free";
    protected static final String SYSTEM_MEM_CACHE = "system.mem.cache";
    protected static final String SYSTEM_MEM_TOTAL = "system.mem.total";
    protected static final String SYSTEM_MEM_BUFF = "system.mem.buff";
    protected static final String SYSTEM_DISK = "system.disk";
    protected static final String SYSTEM_NET_IFIN = "system.net.ifin";
    protected static final String SYSTEM_NET_IFOUT = "system.net.ifout";
    protected static final String SYSTEM_NET_PKTIN = "system.net.pktin";
    protected static final String SYSTEM_NET_PKTOUT = "system.net.pktout";
    protected static final String SYSTEM_NET_TCPRETRAN = "system.net.tcpretran";
    private final KMonitor kMonitor = KMonitorFactory.getKMonitor("system_kmonitor");
    private ImmutableMetricTags systemTags;
    private boolean cpuEnabled;
    private boolean loadEnabled;
    private boolean memEnabled;
    private boolean diskEnabled;
    private boolean netEnabled;
    private boolean inited;
    private boolean enabled;
    private static String RUN_FILE = "./check_tsar.pl";
    private static String SCRIPT_FILE = "/script/alimonitor/check_tsar.pl";

    public AlimonitorCollector(ImmutableMetricTags systemTags) {
        this.systemTags = systemTags;
        this.cpuEnabled = KMonitorConfig.isSystemAlimonitorCpuEnabled();
        this.loadEnabled = KMonitorConfig.isSystemAlimonitorLoadEnabled();
        this.memEnabled = KMonitorConfig.isSystemAlimonitorMemEnabled();
        this.diskEnabled = KMonitorConfig.isSystemAlimonitorDiskEnabled();
        this.netEnabled = KMonitorConfig.isSystemAlimonitorNetEnabled();
        this.inited = false;
        this.enabled = false;
        if (this.cpuEnabled || this.loadEnabled || this.memEnabled || this.diskEnabled || this.netEnabled) {
            this.enabled = true;
            this.inited = this.createRunFile();
            if (this.inited) {
                this.kMonitor.register(SYSTEM_CPU, MetricType.GAUGE);
                this.kMonitor.register(SYSTEM_LOAD1, MetricType.GAUGE);
                this.kMonitor.register(SYSTEM_LOAD5, MetricType.GAUGE);
                this.kMonitor.register(SYSTEM_LOAD15, MetricType.GAUGE);
                this.kMonitor.register(SYSTEM_MEM, MetricType.GAUGE);
                this.kMonitor.register(SYSTEM_MEM_BUFF, MetricType.GAUGE);
                this.kMonitor.register(SYSTEM_MEM_CACHE, MetricType.GAUGE);
                this.kMonitor.register(SYSTEM_MEM_FREE, MetricType.GAUGE);
                this.kMonitor.register(SYSTEM_MEM_USED, MetricType.GAUGE);
                this.kMonitor.register(SYSTEM_MEM_TOTAL, MetricType.GAUGE);
                this.kMonitor.register(SYSTEM_DISK, MetricType.GAUGE);
                this.kMonitor.register(SYSTEM_NET_IFIN, MetricType.GAUGE);
                this.kMonitor.register(SYSTEM_NET_IFOUT, MetricType.GAUGE);
                this.kMonitor.register(SYSTEM_NET_PKTIN, MetricType.GAUGE);
                this.kMonitor.register(SYSTEM_NET_PKTOUT, MetricType.GAUGE);
                this.kMonitor.register(SYSTEM_NET_TCPRETRAN, MetricType.GAUGE);
                LOG.info((Object)("alimonitor collector init:" + String.valueOf(this.inited)));
            }
        }
    }

    private boolean createRunFile() {
        String content = FileUtil.readJarFile(SCRIPT_FILE);
        return FileUtil.saveFile(content, RUN_FILE);
    }

    @Override
    public void collect() throws IOException {
        if (this.enabled) {
            if (this.inited) {
                if (!EnvUtil.isLinux()) {
                    LOG.error((Object)"only support on linux system");
                    return;
                }
                TsarResult result = Tsar.exec(RUN_FILE);
                if (result != null) {
                    if (result.getError_info().isEmpty()) {
                        TsarResult.System system = result.getMsg().get(0);
                        if (this.cpuEnabled) {
                            this.kMonitor.report(SYSTEM_CPU, this.systemTags, system.getCpu());
                        }
                        if (this.diskEnabled) {
                            this.kMonitor.report(SYSTEM_DISK, this.systemTags, system.getDf_());
                        }
                        if (this.loadEnabled) {
                            this.kMonitor.report(SYSTEM_LOAD1, this.systemTags, system.getLoad1());
                            this.kMonitor.report(SYSTEM_LOAD5, this.systemTags, system.getLoad5());
                            this.kMonitor.report(SYSTEM_LOAD15, this.systemTags, system.getLoad15());
                        }
                        if (this.memEnabled) {
                            this.kMonitor.report(SYSTEM_MEM, this.systemTags, system.getMem());
                            this.kMonitor.report(SYSTEM_MEM_USED, this.systemTags, system.getMem_used());
                            this.kMonitor.report(SYSTEM_MEM_FREE, this.systemTags, system.getMem_free());
                            this.kMonitor.report(SYSTEM_MEM_BUFF, this.systemTags, system.getMem_buff());
                            this.kMonitor.report(SYSTEM_MEM_CACHE, this.systemTags, system.getMem_cach());
                            this.kMonitor.report(SYSTEM_MEM_TOTAL, this.systemTags, system.getMem_total());
                        }
                        if (this.netEnabled) {
                            this.kMonitor.report(SYSTEM_NET_IFIN, this.systemTags, system.getIfin());
                            this.kMonitor.report(SYSTEM_NET_IFOUT, this.systemTags, system.getIfout());
                            this.kMonitor.report(SYSTEM_NET_PKTIN, this.systemTags, system.getPktin());
                            this.kMonitor.report(SYSTEM_NET_PKTOUT, this.systemTags, system.getPktout());
                            this.kMonitor.report(SYSTEM_NET_TCPRETRAN, this.systemTags, system.getTCPretr());
                        }
                    } else {
                        LOG.warn((Object)("collect with error message:" + result.getError_info()));
                    }
                } else {
                    LOG.error((Object)"run alimonitor collector failed");
                }
            } else {
                LOG.error((Object)"cannot create alimonitor collect script");
            }
        }
    }
}

