/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.kmonitor.system;

import com.taobao.kmonitor.ImmutableMetricTags;
import com.taobao.kmonitor.KMonitor;
import com.taobao.kmonitor.KMonitorFactory;
import com.taobao.kmonitor.MetricType;
import com.taobao.kmonitor.system.Collector;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.lang.management.ThreadMXBean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JvmStatusCollector
implements Collector {
    private static final Log LOG = LogFactory.getLog(JvmStatusCollector.class);
    protected static final String JVM_HEAP_USED = "app.jvm.heap_used_MB";
    protected static final String JVM_HEAP_NONUSED = "app.jvm.heap_non_used_MB";
    protected static final String JVM_HEAP_USED_COMMIT = "app.jvm.heap_used_commit_MB";
    protected static final String JVM_HEAP_NONUSED_COMMIT = "app.jvm.heap_non_used_commit_MB";
    protected static final String JVM_GC_COUNT = "app.jvm.gc_count";
    protected static final String JVM_GC_USE_TIME = "app.jvm.gc_use_time_ms";
    protected static final String JVM_THREAD_COUNT = "app.jvm.thread_count";
    private final KMonitor kMonitor = KMonitorFactory.getKMonitor("system_kmonitor");
    private ImmutableMetricTags systemTags;

    public JvmStatusCollector(ImmutableMetricTags systemTags) {
        this.systemTags = systemTags;
        this.kMonitor.register(JVM_HEAP_NONUSED, MetricType.GAUGE);
        this.kMonitor.register(JVM_HEAP_NONUSED_COMMIT, MetricType.GAUGE);
        this.kMonitor.register(JVM_HEAP_USED, MetricType.GAUGE);
        this.kMonitor.register(JVM_HEAP_USED_COMMIT, MetricType.GAUGE);
        this.kMonitor.register(JVM_GC_COUNT, MetricType.GAUGE);
        this.kMonitor.register(JVM_GC_USE_TIME, MetricType.GAUGE);
        this.kMonitor.register(JVM_THREAD_COUNT, MetricType.GAUGE);
    }

    @Override
    public void collect() {
        MemoryMXBean memoryMXBean = ManagementFactory.getMemoryMXBean();
        MemoryUsage memNonHeap = memoryMXBean.getNonHeapMemoryUsage();
        MemoryUsage memHeap = memoryMXBean.getHeapMemoryUsage();
        ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
        int threadCount = threadMXBean.getThreadCount();
        double memNonHeapUsed = (double)memNonHeap.getUsed() / 1048576.0;
        this.kMonitor.report(JVM_HEAP_NONUSED, this.systemTags, memNonHeapUsed);
        double memNonHeapCommitted = (double)memNonHeap.getCommitted() / 1048576.0;
        this.kMonitor.report(JVM_HEAP_NONUSED_COMMIT, this.systemTags, memNonHeapCommitted);
        double memHeapUsed = (double)memHeap.getUsed() / 1048576.0;
        this.kMonitor.report(JVM_HEAP_USED, this.systemTags, memHeapUsed);
        double memHeapCommitted = (double)memHeap.getCommitted() / 1048576.0;
        this.kMonitor.report(JVM_HEAP_USED_COMMIT, this.systemTags, memHeapCommitted);
        this.kMonitor.report(JVM_THREAD_COUNT, this.systemTags, threadCount);
        long gcCount = 0L;
        long gcTime = 0L;
        for (GarbageCollectorMXBean bean : ManagementFactory.getGarbageCollectorMXBeans()) {
            gcCount += bean.getCollectionCount();
            gcTime += bean.getCollectionTime();
        }
        this.kMonitor.report(JVM_GC_COUNT, this.systemTags, gcCount);
        this.kMonitor.report(JVM_GC_USE_TIME, this.systemTags, gcTime);
    }
}

