/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.kmonitor.system;

import com.taobao.kmonitor.ImmutableMetricTags;
import com.taobao.kmonitor.KMonitor;
import com.taobao.kmonitor.KMonitorFactory;
import com.taobao.kmonitor.MetricType;
import com.taobao.kmonitor.system.Collector;
import com.taobao.kmonitor.tool.EnvUtil;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ProcessCpuCollector
implements Collector {
    private static final Log LOG = LogFactory.getLog(ProcessCpuCollector.class);
    private static final String CPU_STAT_FILE = "/proc/stat";
    private static final String PROCESS_STAT_FILE = "/proc/self/stat";
    protected static final String PROCESS_CPU_METRIC_NAME = "app.proc.cpu";
    private final int AVAILABLE_PROCESSOR_COUNT = Runtime.getRuntime().availableProcessors();
    private final KMonitor kMonitor = KMonitorFactory.getKMonitor("system_kmonitor");
    private double currentSystemCpuTotal = 0.0;
    private double currentProcCpuClock = 0.0;
    private ImmutableMetricTags systemTags;

    public ProcessCpuCollector(ImmutableMetricTags systemTags) {
        this.systemTags = systemTags;
        this.kMonitor.register(PROCESS_CPU_METRIC_NAME, MetricType.GAUGE);
    }

    @Override
    public void collect() throws Exception {
        if (EnvUtil.isLinux()) {
            double procCpuClock = this.getProcessCpuClock();
            double totalCpuStat = this.getTotalCpuClock();
            if (totalCpuStat == 0.0) {
                return;
            }
            double cpuUsagePercent = procCpuClock * 100.0 / totalCpuStat;
            this.kMonitor.report(PROCESS_CPU_METRIC_NAME, this.systemTags, cpuUsagePercent * (double)this.AVAILABLE_PROCESSOR_COUNT);
        } else {
            LOG.warn((Object)"collect cpu metric failed for your system is not linux");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getFirstLineFromFile(String fileName) throws IOException {
        try (BufferedReader br = null;){
            String line;
            br = new BufferedReader(new FileReader(fileName));
            String string = line = br.readLine();
            return string;
        }
    }

    private double getProcessCpuClock() throws IOException {
        double lastProcCpuClock = this.currentProcCpuClock;
        String content = this.getFirstLineFromFile(PROCESS_STAT_FILE);
        if (content == null) {
            throw new IOException("read /proc/self/stat null !");
        }
        String[] processStats = content.split(" ", -1);
        if (processStats.length < 17) {
            LOG.error((Object)("parse cpu stat file failed! the first line is:" + content));
            throw new IOException("parse process stat file failed!");
        }
        int rBracketPos = 0;
        for (int i = processStats.length - 1; i > 0; --i) {
            if (!processStats[i].contains(")")) continue;
            rBracketPos = i;
            break;
        }
        if (rBracketPos == 0) {
            throw new IOException("get right bracket pos error");
        }
        double cpuTotal = 0.0;
        for (int i = rBracketPos + 12; i < rBracketPos + 16; ++i) {
            cpuTotal += Double.parseDouble(processStats[i]);
        }
        this.currentProcCpuClock = cpuTotal;
        return this.currentProcCpuClock - lastProcCpuClock;
    }

    private double getTotalCpuClock() throws IOException {
        double lastSystemCpuTotal = this.currentSystemCpuTotal;
        String line = this.getFirstLineFromFile(CPU_STAT_FILE);
        if (line == null) {
            throw new IOException("read /proc/stat null !");
        }
        String[] cpuStats = line.split(" ", -1);
        if (cpuStats.length < 11) {
            LOG.error((Object)("parse cpu stat file failed! the first line is:" + line));
            throw new IOException("parse cpu stat file failed!");
        }
        double statCpuTotal = 0.0;
        for (int i = 2; i < cpuStats.length; ++i) {
            statCpuTotal += Double.parseDouble(cpuStats[i]);
        }
        this.currentSystemCpuTotal = statCpuTotal;
        return this.currentSystemCpuTotal - lastSystemCpuTotal;
    }
}

