/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.kmonitor.system;

import com.taobao.kmonitor.ImmutableMetricTags;
import com.taobao.kmonitor.KMonitor;
import com.taobao.kmonitor.KMonitorFactory;
import com.taobao.kmonitor.MetricType;
import com.taobao.kmonitor.system.Collector;
import com.taobao.kmonitor.tool.EnvUtil;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ProcessMemCollector
implements Collector {
    private static final Log LOG = LogFactory.getLog(ProcessMemCollector.class);
    private static final String MEMORY_TOTAL_USE_TOKEN = "VmSize";
    private static final String MEMORY_RSS_USE_TOKEN = "VmRSS";
    private static final String MEM_STAT_FILE = "/proc/self/status";
    protected static final String PROCESS_MEM_SIZE_METRIC_NAME = "app.proc.mem_size_MB";
    protected static final String PROCESS_MEM_RSS_METRIC_NAME = "app.proc.mem_rss_MB";
    private final KMonitor kMonitor = KMonitorFactory.getKMonitor("system_kmonitor");
    private ImmutableMetricTags systemTags;

    public ProcessMemCollector(ImmutableMetricTags systemTags) {
        this.systemTags = systemTags;
        this.kMonitor.register(PROCESS_MEM_SIZE_METRIC_NAME, MetricType.GAUGE);
        this.kMonitor.register(PROCESS_MEM_RSS_METRIC_NAME, MetricType.GAUGE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void collect() throws IOException {
        block8: {
            if (EnvUtil.isLinux()) {
                try (BufferedReader br = null;){
                    br = new BufferedReader(new FileReader(MEM_STAT_FILE));
                    while (true) {
                        String line;
                        if (null == (line = br.readLine())) {
                            break block8;
                        }
                        if (line.startsWith(MEMORY_TOTAL_USE_TOKEN)) {
                            double totalMem = this.getNumber(line) / 1024.0;
                            this.kMonitor.report(PROCESS_MEM_SIZE_METRIC_NAME, this.systemTags, totalMem);
                            continue;
                        }
                        if (!line.startsWith(MEMORY_RSS_USE_TOKEN)) continue;
                        double rssMem = this.getNumber(line) / 1024.0;
                        this.kMonitor.report(PROCESS_MEM_RSS_METRIC_NAME, this.systemTags, rssMem);
                    }
                }
            }
            LOG.warn((Object)"collect mem metric failed for your system is not linux");
        }
    }

    private double getNumber(String line) {
        int beginIndex = line.indexOf(":") + 1;
        int endIndex = line.indexOf("kB") - 1;
        String memSize = line.substring(beginIndex, endIndex).trim();
        return Double.parseDouble(memSize);
    }
}

