/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.kmonitor.system;

import com.taobao.kmonitor.ImmutableMetricTags;
import com.taobao.kmonitor.common.ToolUtils;
import com.taobao.kmonitor.core.MetricsTags;
import com.taobao.kmonitor.system.AlimonitorCollector;
import com.taobao.kmonitor.system.Collector;
import com.taobao.kmonitor.system.JvmStatusCollector;
import com.taobao.kmonitor.system.ProcessCpuCollector;
import com.taobao.kmonitor.system.ProcessMemCollector;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SystemMetricsManager {
    private static final Log LOG = LogFactory.getLog(SystemMetricsManager.class);
    private Timer timer = null;
    private boolean enabled;
    private final List<Collector> collectors = new ArrayList<Collector>();
    private ImmutableMetricTags systemTags = ImmutableMetricTags.EMPTY_METRIC_TAGS;

    public SystemMetricsManager(boolean enabled) {
        this.enabled = enabled;
        if (enabled) {
            LOG.info((Object)"System metrics enabled");
            this.systemTags = new ImmutableMetricTags("pid", this.getPid());
            LOG.info((Object)("set default tags for system metrics: " + this.systemTags));
        } else {
            LOG.info((Object)"System metrics disabled");
        }
    }

    public void addMetricsTags(MetricsTags metricTags) {
        this.systemTags = ImmutableMetricTags.mergeMetricsTags(this.systemTags, metricTags);
    }

    public void delMetricsTags(MetricsTags metricTags) {
        this.systemTags = ImmutableMetricTags.removeMetricTags(this.systemTags, metricTags);
    }

    public void initCollectors() {
        if (!this.enabled) {
            return;
        }
        ProcessCpuCollector cpuCollector = new ProcessCpuCollector(this.systemTags);
        this.collectors.add(cpuCollector);
        ProcessMemCollector memCollector = new ProcessMemCollector(this.systemTags);
        this.collectors.add(memCollector);
        JvmStatusCollector jvmHeapCollector = new JvmStatusCollector(this.systemTags);
        this.collectors.add(jvmHeapCollector);
        AlimonitorCollector aliCollector = new AlimonitorCollector(this.systemTags);
        this.collectors.add(aliCollector);
    }

    public void startReport(long reportPeriod) {
        if (!this.enabled) {
            return;
        }
        this.timer = new Timer(true);
        this.timer.schedule((TimerTask)new CollectMetricsTask(), 0L, reportPeriod * 1000L);
    }

    public void stopReport() {
        if (this.timer != null) {
            this.timer.purge();
            this.timer.cancel();
        }
        this.timer = null;
    }

    private void collectMetrics() {
        for (Collector collector : this.collectors) {
            try {
                collector.collect();
            }
            catch (Exception e) {
                LOG.error((Object)ToolUtils.throwableToString(e));
            }
        }
    }

    private String getPid() {
        String name = ManagementFactory.getRuntimeMXBean().getName();
        return name.split("@")[0];
    }

    class CollectMetricsTask
    extends TimerTask {
        CollectMetricsTask() {
        }

        @Override
        public void run() {
            SystemMetricsManager.this.collectMetrics();
        }
    }
}

