/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.kmonitor.tool;

import com.taobao.kmonitor.common.ToolUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUtil {
    private static final Logger logger = LoggerFactory.getLogger(FileUtil.class);

    public static String readJarFile(String path) {
        return FileUtil.readJarFile(FileUtil.class, path, "UTF-8");
    }

    public static String readJarFile(Class clazz, String path, String charset) {
        InputStream stream = clazz.getResourceAsStream(path);
        return FileUtil.inputStreamToString(stream, charset);
    }

    public static String inputStreamToString(InputStream stream, String charset) {
        int bufferSize = 1024;
        char[] buffer = new char[1024];
        StringBuilder out = new StringBuilder();
        try {
            InputStreamReader in = new InputStreamReader(stream, charset);
            while (true) {
                int rsz = 0;
                rsz = ((Reader)in).read(buffer, 0, buffer.length);
                if (rsz >= 0) {
                    out.append(buffer, 0, rsz);
                    continue;
                }
                break;
            }
        }
        catch (IOException e) {
            logger.error(ToolUtils.throwableToString(e));
        }
        return out.toString();
    }

    public static boolean deleteFile(String filename) {
        boolean res = false;
        File file = new File(filename);
        if (file.exists()) {
            file.delete();
            res = true;
        }
        return res;
    }

    public static boolean saveFile(String content, String filename) {
        byte[] sourceByte;
        boolean res = false;
        if (content != null && null != (sourceByte = content.getBytes())) {
            try {
                File file = new File(filename);
                if (!file.exists()) {
                    File dir = new File(file.getParent());
                    dir.mkdirs();
                    file.createNewFile();
                }
                FileOutputStream outStream = new FileOutputStream(file);
                outStream.write(sourceByte);
                outStream.close();
                outStream.flush();
                res = true;
            }
            catch (Exception e) {
                logger.error(ToolUtils.throwableToString(e));
            }
        }
        return res;
    }
}

