/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.kmonitor.tool;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.taobao.kmonitor.common.ToolUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonUtil {
    private static final Logger logger = LoggerFactory.getLogger(JsonUtil.class);
    private static ObjectMapper mapper;

    public static void init() {
        mapper = new ObjectMapper();
        mapper.configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true);
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }

    public static Object toObject(String json, Class<?> clazz) {
        return JsonUtil.toObject(json, clazz, false);
    }

    public static Object toObject(String json, Class<?> clazz, boolean force) {
        Object obj = null;
        try {
            if (force) {
                JsonNode node = (JsonNode)mapper.readValue(json, JsonNode.class);
                json = node.toString();
            }
            obj = mapper.readValue(json, clazz);
        }
        catch (Exception var4) {
            logger.error(ToolUtils.throwableToString(var4));
        }
        return obj;
    }

    public static String toString(Object obj) {
        String res = "";
        try {
            res = mapper.writeValueAsString(obj);
        }
        catch (JsonProcessingException var3) {
            logger.error(ToolUtils.throwableToString(var3));
        }
        return res;
    }

    static {
        JsonUtil.init();
    }
}

