/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.kmonitor.tool;

import com.taobao.kmonitor.common.ToolUtils;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetWorkUtil {
    private static final Logger logger = LoggerFactory.getLogger(NetWorkUtil.class);
    private static final String DEFAULT_LOCAL_HOST = "localhost";
    private static final Pattern IPV4_PATTERN = Pattern.compile("^(([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.){3}([01]?\\d\\d?|2[0-4]\\d|25[0-5])$");
    private static String currentHostname = null;

    public static boolean isIpv4(String s) {
        return IPV4_PATTERN.matcher(s).matches();
    }

    public static String getLocalIp() {
        String address;
        try {
            address = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e) {
            logger.error(ToolUtils.throwableToString(e));
            address = DEFAULT_LOCAL_HOST;
        }
        return address;
    }

    public static String getCacheLocalHostName() {
        if (currentHostname == null) {
            currentHostname = NetWorkUtil.getLoaclHostname();
        }
        return currentHostname;
    }

    public static String getLoaclHostname() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (Exception e) {
            logger.error(ToolUtils.throwableToString(e));
            return DEFAULT_LOCAL_HOST;
        }
    }
}

