#!/usr/bin/perl
use warnings;
#use strict;

my $tsar = `tsar --check --apache --cpu --mem --load --io --traffic --tcp --partition --nginx --swap`;
my @line = split("\n",$tsar,2);
if ($line[1] ne '') {
        print_json(1501,'Execution error', "");
        exit 1;
}
my @results = split("\t",$tsar,3);

my @records=split(/\s+/,$results[2]);


my %h=();

foreach (@records){

        my @items=split(':',$_);
        if( $#items == 1 ){
                my @values=split('=', $items[1]);
                if ( $#values != 1) {
                        print_json(1503,'Execution error', "");
                        exit 1;
                }
                next if ($values[1] eq '-' or $values[1] eq 'null' or $values[1] == -1);
                $h{$items[0]}{$values[0]}=$values[1];

        }elsif( $#items == 2 ) {
                my @values=split('=', $items[2]);
                if ( $#values != 1) {
                        print_json(1503,'Execution error', "");
                        exit 1;
                }
                next if ($values[1] eq '-' or $values[1] eq 'null' or $values[1] == -1);
                $h{$items[0]}{$items[1]}{$values[0]}=$values[1];
        }else {
                print_json(1502,'Execution error', "");
                exit 1;
        }
}

my $output="";

$output .= format_out('cpu','cpu:util');

$output .= format_out('mem','mem:util');

$output .= format_out('mem_free','mem:free',1024*1024);

$output .= format_out('mem_used','mem:used',1024*1024);

$output .= format_out('mem_buff','mem:buff',1024*1024);

$output .= format_out('mem_cach','mem:cach',1024*1024);

$output .= format_out('mem_total','mem:total',1024*1024);

$output .= format_out('sda','io:sda:util');

$output .= format_out('df_home_admin','partition:/home/admin:util');

$output .= format_out('df_home','partition:/home:util');

$output .= format_out('df_','partition:/:util');

$output .= format_out('df_boot','partition:/boot:util');

$output .= format_out('df_tmp','partition:/tmp:util');

$output .= format_out('df_var','partition:/var:util');

$output .= format_out('apache_qps','apache:qps');

$output .= format_out('apache_rt','apache:rt');

$output .= format_out('nginx_qps','nginx:qps');

$output .= format_out('nginx_rt','nginx:rt');

$output .= format_out('load1','load:load1');

$output .= format_out('load5','load:load5');

$output .= format_out('load15','load:load15');

$output .= format_out('ifin','traffic:bytin',1024);

$output .= format_out('ifout','traffic:bytout',1024);

$output .= format_out('pktin','traffic:pktin');

$output .= format_out('pktout','traffic:pktout');

$fuck = format_out('TCPretr','tcp:retran');
substr($fuck,-1,1)="";

$output .= $fuck;


print_json(0,'', "$output");

sub print_json {
    my ($script_status,$error_message,$MSG)=@_;
    print "{\n\"collection_flag\":$script_status,\n\"error_info\":\"$error_message\",\n\"MSG\":[\n{$MSG}\n\t]\n}";
}

sub format_out {
        my ($item,$keys,$match)=@_;
        my @data=split(":",$keys);
        my $length=scalar(@data);
        my $value;
        if ($length == 2) {
                if(exists $h{$data[0]}{$data[1]}) {
                        if(defined($match)) {
                                $value=$h{$data[0]}{$data[1]}/$match;
                        }else {
                $value=$h{$data[0]}{$data[1]};
                        }
                        return "\'$item\': $value,";
                }
        }elsif($length == 3) {
                if(exists $h{$data[0]}{$data[1]}{$data[2]}) {
                        if(defined($match)) {
                $value=$h{$data[0]}{$data[1]}{$data[2]}/$match;
                }else {
                $value=$h{$data[0]}{$data[1]}{$data[2]};
                }
            return "\'$item\': $value,";
                }
        }

}