/*
 * Marketing API
 * Marketing API
 *
 * OpenAPI spec version: 1.3
 *
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

package com.tencent.ads.api;

import com.google.gson.reflect.TypeToken;
import com.tencent.ads.ApiCallback;
import com.tencent.ads.ApiClient;
import com.tencent.ads.ApiException;
import com.tencent.ads.ApiResponse;
import com.tencent.ads.Configuration;
import com.tencent.ads.Pair;
import com.tencent.ads.ProgressRequestBody;
import com.tencent.ads.ProgressResponseBody;
import com.tencent.ads.model.WxPackageAccountGetResponse;
import com.tencent.ads.model.WxPackageAccountUpdateResponse;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class WxPackageAccountApi {
  private ApiClient apiClient;

  public WxPackageAccountApi() {
    this(Configuration.getDefaultApiClient());
  }

  public WxPackageAccountApi(ApiClient apiClient) {
    this.apiClient = apiClient;
  }

  public ApiClient getApiClient() {
    return apiClient;
  }

  public void setApiClient(ApiClient apiClient) {
    this.apiClient = apiClient;
  }

  /**
   * Build call for wxPackageAccountGet
   *
   * @param accountId (required)
   * @param pageSize (optional)
   * @param pageIndex (optional)
   * @param beginTime (optional)
   * @param endTime (optional)
   * @param keyword (optional)
   * @param fields 返回参数的字段列表 (optional)
   * @param progressListener Progress listener
   * @param progressRequestListener Progress request listener
   * @return Call to execute
   * @throws ApiException If fail to serialize the request body object
   */
  public com.squareup.okhttp.Call wxPackageAccountGetCall(
      Long accountId,
      Long pageSize,
      Long pageIndex,
      String beginTime,
      String endTime,
      String keyword,
      List<String> fields,
      final ProgressResponseBody.ProgressListener progressListener,
      final ProgressRequestBody.ProgressRequestListener progressRequestListener)
      throws ApiException {
    Object localVarPostBody = null;

    // create path and map variables
    String localVarPath = "/wx_package_account/get";

    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    if (accountId != null)
      localVarQueryParams.addAll(apiClient.parameterToPair("account_id", accountId));
    if (pageSize != null)
      localVarQueryParams.addAll(apiClient.parameterToPair("page_size", pageSize));
    if (pageIndex != null)
      localVarQueryParams.addAll(apiClient.parameterToPair("page_index", pageIndex));
    if (beginTime != null)
      localVarQueryParams.addAll(apiClient.parameterToPair("begin_time", beginTime));
    if (endTime != null) localVarQueryParams.addAll(apiClient.parameterToPair("end_time", endTime));
    if (keyword != null) localVarQueryParams.addAll(apiClient.parameterToPair("keyword", keyword));
    if (fields != null)
      localVarCollectionQueryParams.addAll(apiClient.parameterToPairs("multi", "fields", fields));

    Map<String, String> localVarHeaderParams = new HashMap<String, String>();

    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    final String[] localVarAccepts = {"application/json"};
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
    if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

    final String[] localVarContentTypes = {"text/plain"};
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
    localVarHeaderParams.put("Content-Type", localVarContentType);

    if (progressListener != null) {
      apiClient
          .getHttpClient()
          .networkInterceptors()
          .add(
              new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(
                    com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                  com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                  return originalResponse
                      .newBuilder()
                      .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                      .build();
                }
              });
    }

    String[] localVarAuthNames = new String[] {"accessToken", "nonce", "timestamp"};
    return apiClient.buildCall(
        localVarPath,
        "GET",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarPostBody,
        localVarHeaderParams,
        localVarFormParams,
        localVarAuthNames,
        progressRequestListener);
  }

  @SuppressWarnings("rawtypes")
  private com.squareup.okhttp.Call wxPackageAccountGetValidateBeforeCall(
      Long accountId,
      Long pageSize,
      Long pageIndex,
      String beginTime,
      String endTime,
      String keyword,
      List<String> fields,
      final ProgressResponseBody.ProgressListener progressListener,
      final ProgressRequestBody.ProgressRequestListener progressRequestListener)
      throws ApiException {

    // verify the required parameter 'accountId' is set
    if (accountId == null) {
      throw new ApiException(
          "Missing the required parameter 'accountId' when calling wxPackageAccountGet(Async)");
    }

    com.squareup.okhttp.Call call =
        wxPackageAccountGetCall(
            accountId,
            pageSize,
            pageIndex,
            beginTime,
            endTime,
            keyword,
            fields,
            progressListener,
            progressRequestListener);
    return call;
  }

  /**
   * 获取蹊径微信号列表
   *
   * @param accountId (required)
   * @param pageSize (optional)
   * @param pageIndex (optional)
   * @param beginTime (optional)
   * @param endTime (optional)
   * @param keyword (optional)
   * @param fields 返回参数的字段列表 (optional)
   * @return WxPackageAccountGetResponse
   * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
   *     response body
   */
  public WxPackageAccountGetResponse wxPackageAccountGet(
      Long accountId,
      Long pageSize,
      Long pageIndex,
      String beginTime,
      String endTime,
      String keyword,
      List<String> fields)
      throws ApiException {
    ApiResponse<WxPackageAccountGetResponse> resp =
        wxPackageAccountGetWithHttpInfo(
            accountId, pageSize, pageIndex, beginTime, endTime, keyword, fields);
    return resp.getData();
  }

  /**
   * 获取蹊径微信号列表
   *
   * @param accountId (required)
   * @param pageSize (optional)
   * @param pageIndex (optional)
   * @param beginTime (optional)
   * @param endTime (optional)
   * @param keyword (optional)
   * @param fields 返回参数的字段列表 (optional)
   * @return ApiResponse&lt;WxPackageAccountGetResponse&gt;
   * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
   *     response body
   */
  public ApiResponse<WxPackageAccountGetResponse> wxPackageAccountGetWithHttpInfo(
      Long accountId,
      Long pageSize,
      Long pageIndex,
      String beginTime,
      String endTime,
      String keyword,
      List<String> fields)
      throws ApiException {
    com.squareup.okhttp.Call call =
        wxPackageAccountGetValidateBeforeCall(
            accountId, pageSize, pageIndex, beginTime, endTime, keyword, fields, null, null);
    Type localVarReturnType = new TypeToken<WxPackageAccountGetResponse>() {}.getType();
    return apiClient.execute(call, localVarReturnType);
  }

  /**
   * 获取蹊径微信号列表 (asynchronously)
   *
   * @param accountId (required)
   * @param pageSize (optional)
   * @param pageIndex (optional)
   * @param beginTime (optional)
   * @param endTime (optional)
   * @param keyword (optional)
   * @param fields 返回参数的字段列表 (optional)
   * @param callback The callback to be executed when the API call finishes
   * @return The request call
   * @throws ApiException If fail to process the API call, e.g. serializing the request body object
   */
  public com.squareup.okhttp.Call wxPackageAccountGetAsync(
      Long accountId,
      Long pageSize,
      Long pageIndex,
      String beginTime,
      String endTime,
      String keyword,
      List<String> fields,
      final ApiCallback<WxPackageAccountGetResponse> callback)
      throws ApiException {

    ProgressResponseBody.ProgressListener progressListener = null;
    ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

    if (callback != null) {
      progressListener =
          new ProgressResponseBody.ProgressListener() {
            @Override
            public void update(long bytesRead, long contentLength, boolean done) {
              callback.onDownloadProgress(bytesRead, contentLength, done);
            }
          };

      progressRequestListener =
          new ProgressRequestBody.ProgressRequestListener() {
            @Override
            public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
              callback.onUploadProgress(bytesWritten, contentLength, done);
            }
          };
    }

    com.squareup.okhttp.Call call =
        wxPackageAccountGetValidateBeforeCall(
            accountId,
            pageSize,
            pageIndex,
            beginTime,
            endTime,
            keyword,
            fields,
            progressListener,
            progressRequestListener);
    Type localVarReturnType = new TypeToken<WxPackageAccountGetResponse>() {}.getType();
    apiClient.executeAsync(call, localVarReturnType, callback);
    return call;
  }
  /**
   * Build call for wxPackageAccountUpdate
   *
   * @param accountId (required)
   * @param wechatId (required)
   * @param nickName (optional)
   * @param file (optional)
   * @param enableFlag (optional)
   * @param progressListener Progress listener
   * @param progressRequestListener Progress request listener
   * @return Call to execute
   * @throws ApiException If fail to serialize the request body object
   */
  public com.squareup.okhttp.Call wxPackageAccountUpdateCall(
      Long accountId,
      Long wechatId,
      String nickName,
      File file,
      Long enableFlag,
      final ProgressResponseBody.ProgressListener progressListener,
      final ProgressRequestBody.ProgressRequestListener progressRequestListener)
      throws ApiException {
    Object localVarPostBody = null;

    // create path and map variables
    String localVarPath = "/wx_package_account/update";

    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

    Map<String, String> localVarHeaderParams = new HashMap<String, String>();

    Map<String, Object> localVarFormParams = new HashMap<String, Object>();
    if (accountId != null) localVarFormParams.put("account_id", accountId);
    if (wechatId != null) localVarFormParams.put("wechat_id", wechatId);
    if (nickName != null) localVarFormParams.put("nick_name", nickName);
    if (file != null) localVarFormParams.put("file", file);
    if (enableFlag != null) localVarFormParams.put("enable_flag", enableFlag);

    final String[] localVarAccepts = {"application/json"};
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
    if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

    final String[] localVarContentTypes = {"multipart/form-data"};
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
    localVarHeaderParams.put("Content-Type", localVarContentType);

    if (progressListener != null) {
      apiClient
          .getHttpClient()
          .networkInterceptors()
          .add(
              new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(
                    com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                  com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                  return originalResponse
                      .newBuilder()
                      .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                      .build();
                }
              });
    }

    String[] localVarAuthNames = new String[] {"accessToken", "nonce", "timestamp"};
    return apiClient.buildCall(
        localVarPath,
        "POST",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarPostBody,
        localVarHeaderParams,
        localVarFormParams,
        localVarAuthNames,
        progressRequestListener);
  }

  @SuppressWarnings("rawtypes")
  private com.squareup.okhttp.Call wxPackageAccountUpdateValidateBeforeCall(
      Long accountId,
      Long wechatId,
      String nickName,
      File file,
      Long enableFlag,
      final ProgressResponseBody.ProgressListener progressListener,
      final ProgressRequestBody.ProgressRequestListener progressRequestListener)
      throws ApiException {

    // verify the required parameter 'accountId' is set
    if (accountId == null) {
      throw new ApiException(
          "Missing the required parameter 'accountId' when calling wxPackageAccountUpdate(Async)");
    }

    // verify the required parameter 'wechatId' is set
    if (wechatId == null) {
      throw new ApiException(
          "Missing the required parameter 'wechatId' when calling wxPackageAccountUpdate(Async)");
    }

    com.squareup.okhttp.Call call =
        wxPackageAccountUpdateCall(
            accountId,
            wechatId,
            nickName,
            file,
            enableFlag,
            progressListener,
            progressRequestListener);
    return call;
  }

  /**
   * 更新蹊径微信号
   *
   * @param accountId (required)
   * @param wechatId (required)
   * @param nickName (optional)
   * @param file (optional)
   * @param enableFlag (optional)
   * @return WxPackageAccountUpdateResponse
   * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
   *     response body
   */
  public WxPackageAccountUpdateResponse wxPackageAccountUpdate(
      Long accountId, Long wechatId, String nickName, File file, Long enableFlag)
      throws ApiException {
    ApiResponse<WxPackageAccountUpdateResponse> resp =
        wxPackageAccountUpdateWithHttpInfo(accountId, wechatId, nickName, file, enableFlag);
    return resp.getData();
  }

  /**
   * 更新蹊径微信号
   *
   * @param accountId (required)
   * @param wechatId (required)
   * @param nickName (optional)
   * @param file (optional)
   * @param enableFlag (optional)
   * @return ApiResponse&lt;WxPackageAccountUpdateResponse&gt;
   * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
   *     response body
   */
  public ApiResponse<WxPackageAccountUpdateResponse> wxPackageAccountUpdateWithHttpInfo(
      Long accountId, Long wechatId, String nickName, File file, Long enableFlag)
      throws ApiException {
    com.squareup.okhttp.Call call =
        wxPackageAccountUpdateValidateBeforeCall(
            accountId, wechatId, nickName, file, enableFlag, null, null);
    Type localVarReturnType = new TypeToken<WxPackageAccountUpdateResponse>() {}.getType();
    return apiClient.execute(call, localVarReturnType);
  }

  /**
   * 更新蹊径微信号 (asynchronously)
   *
   * @param accountId (required)
   * @param wechatId (required)
   * @param nickName (optional)
   * @param file (optional)
   * @param enableFlag (optional)
   * @param callback The callback to be executed when the API call finishes
   * @return The request call
   * @throws ApiException If fail to process the API call, e.g. serializing the request body object
   */
  public com.squareup.okhttp.Call wxPackageAccountUpdateAsync(
      Long accountId,
      Long wechatId,
      String nickName,
      File file,
      Long enableFlag,
      final ApiCallback<WxPackageAccountUpdateResponse> callback)
      throws ApiException {

    ProgressResponseBody.ProgressListener progressListener = null;
    ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

    if (callback != null) {
      progressListener =
          new ProgressResponseBody.ProgressListener() {
            @Override
            public void update(long bytesRead, long contentLength, boolean done) {
              callback.onDownloadProgress(bytesRead, contentLength, done);
            }
          };

      progressRequestListener =
          new ProgressRequestBody.ProgressRequestListener() {
            @Override
            public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
              callback.onUploadProgress(bytesWritten, contentLength, done);
            }
          };
    }

    com.squareup.okhttp.Call call =
        wxPackageAccountUpdateValidateBeforeCall(
            accountId,
            wechatId,
            nickName,
            file,
            enableFlag,
            progressListener,
            progressRequestListener);
    Type localVarReturnType = new TypeToken<WxPackageAccountUpdateResponse>() {}.getType();
    apiClient.executeAsync(call, localVarReturnType, callback);
    return call;
  }
}
