/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.ads.api;

import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import com.tencent.ads.ApiCallback;
import com.tencent.ads.ApiClient;
import com.tencent.ads.ApiException;
import com.tencent.ads.ApiResponse;
import com.tencent.ads.Configuration;
import com.tencent.ads.Pair;
import com.tencent.ads.ProgressRequestBody;
import com.tencent.ads.ProgressResponseBody;
import com.tencent.ads.model.FilteringStruct;
import com.tencent.ads.model.LocalStoresAddRequest;
import com.tencent.ads.model.LocalStoresAddResponse;
import com.tencent.ads.model.LocalStoresDeleteRequest;
import com.tencent.ads.model.LocalStoresDeleteResponse;
import com.tencent.ads.model.LocalStoresGetResponse;
import com.tencent.ads.model.LocalStoresUpdateRequest;
import com.tencent.ads.model.LocalStoresUpdateResponse;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class LocalStoresApi {
    private ApiClient apiClient;

    public LocalStoresApi() {
        this(Configuration.getDefaultApiClient());
    }

    public LocalStoresApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call localStoresAddCall(LocalStoresAddRequest data, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        LocalStoresAddRequest localVarPostBody = data;
        String localVarPath = "/local_stores/add";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json", "application/xml"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"accessToken", "nonce", "timestamp"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call localStoresAddValidateBeforeCall(LocalStoresAddRequest data, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (data == null) {
            throw new ApiException("Missing the required parameter 'data' when calling localStoresAdd(Async)");
        }
        Call call = this.localStoresAddCall(data, progressListener, progressRequestListener);
        return call;
    }

    public LocalStoresAddResponse localStoresAdd(LocalStoresAddRequest data) throws ApiException {
        ApiResponse<LocalStoresAddResponse> resp = this.localStoresAddWithHttpInfo(data);
        return resp.getData();
    }

    public ApiResponse<LocalStoresAddResponse> localStoresAddWithHttpInfo(LocalStoresAddRequest data) throws ApiException {
        Call call = this.localStoresAddValidateBeforeCall(data, null, null);
        Type localVarReturnType = new TypeToken<LocalStoresAddResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call localStoresAddAsync(LocalStoresAddRequest data, final ApiCallback<LocalStoresAddResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.localStoresAddValidateBeforeCall(data, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<LocalStoresAddResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call localStoresDeleteCall(LocalStoresDeleteRequest data, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        LocalStoresDeleteRequest localVarPostBody = data;
        String localVarPath = "/local_stores/delete";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json", "application/xml"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"accessToken", "nonce", "timestamp"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call localStoresDeleteValidateBeforeCall(LocalStoresDeleteRequest data, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (data == null) {
            throw new ApiException("Missing the required parameter 'data' when calling localStoresDelete(Async)");
        }
        Call call = this.localStoresDeleteCall(data, progressListener, progressRequestListener);
        return call;
    }

    public LocalStoresDeleteResponse localStoresDelete(LocalStoresDeleteRequest data) throws ApiException {
        ApiResponse<LocalStoresDeleteResponse> resp = this.localStoresDeleteWithHttpInfo(data);
        return resp.getData();
    }

    public ApiResponse<LocalStoresDeleteResponse> localStoresDeleteWithHttpInfo(LocalStoresDeleteRequest data) throws ApiException {
        Call call = this.localStoresDeleteValidateBeforeCall(data, null, null);
        Type localVarReturnType = new TypeToken<LocalStoresDeleteResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call localStoresDeleteAsync(LocalStoresDeleteRequest data, final ApiCallback<LocalStoresDeleteResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.localStoresDeleteValidateBeforeCall(data, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<LocalStoresDeleteResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call localStoresGetCall(Long accountId, List<FilteringStruct> filtering, Long page, Long pageSize, List<String> fields, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/local_stores/get";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (accountId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("account_id", accountId));
        }
        if (filtering != null) {
            localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("multi", "filtering", filtering));
        }
        if (page != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("page", page));
        }
        if (pageSize != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("page_size", pageSize));
        }
        if (fields != null) {
            localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("multi", "fields", fields));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"text/plain"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"accessToken", "nonce", "timestamp"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call localStoresGetValidateBeforeCall(Long accountId, List<FilteringStruct> filtering, Long page, Long pageSize, List<String> fields, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (accountId == null) {
            throw new ApiException("Missing the required parameter 'accountId' when calling localStoresGet(Async)");
        }
        Call call = this.localStoresGetCall(accountId, filtering, page, pageSize, fields, progressListener, progressRequestListener);
        return call;
    }

    public LocalStoresGetResponse localStoresGet(Long accountId, List<FilteringStruct> filtering, Long page, Long pageSize, List<String> fields) throws ApiException {
        ApiResponse<LocalStoresGetResponse> resp = this.localStoresGetWithHttpInfo(accountId, filtering, page, pageSize, fields);
        return resp.getData();
    }

    public ApiResponse<LocalStoresGetResponse> localStoresGetWithHttpInfo(Long accountId, List<FilteringStruct> filtering, Long page, Long pageSize, List<String> fields) throws ApiException {
        Call call = this.localStoresGetValidateBeforeCall(accountId, filtering, page, pageSize, fields, null, null);
        Type localVarReturnType = new TypeToken<LocalStoresGetResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call localStoresGetAsync(Long accountId, List<FilteringStruct> filtering, Long page, Long pageSize, List<String> fields, final ApiCallback<LocalStoresGetResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.localStoresGetValidateBeforeCall(accountId, filtering, page, pageSize, fields, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<LocalStoresGetResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call localStoresUpdateCall(LocalStoresUpdateRequest data, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        LocalStoresUpdateRequest localVarPostBody = data;
        String localVarPath = "/local_stores/update";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json", "application/xml"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"accessToken", "nonce", "timestamp"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call localStoresUpdateValidateBeforeCall(LocalStoresUpdateRequest data, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (data == null) {
            throw new ApiException("Missing the required parameter 'data' when calling localStoresUpdate(Async)");
        }
        Call call = this.localStoresUpdateCall(data, progressListener, progressRequestListener);
        return call;
    }

    public LocalStoresUpdateResponse localStoresUpdate(LocalStoresUpdateRequest data) throws ApiException {
        ApiResponse<LocalStoresUpdateResponse> resp = this.localStoresUpdateWithHttpInfo(data);
        return resp.getData();
    }

    public ApiResponse<LocalStoresUpdateResponse> localStoresUpdateWithHttpInfo(LocalStoresUpdateRequest data) throws ApiException {
        Call call = this.localStoresUpdateValidateBeforeCall(data, null, null);
        Type localVarReturnType = new TypeToken<LocalStoresUpdateResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call localStoresUpdateAsync(LocalStoresUpdateRequest data, final ApiCallback<LocalStoresUpdateResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.localStoresUpdateValidateBeforeCall(data, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<LocalStoresUpdateResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

