/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.ads.examples.MoreAds;

import com.tencent.ads.ApiContextConfig;
import com.tencent.ads.ApiException;
import com.tencent.ads.TencentAds;
import com.tencent.ads.exception.TencentAdsResponseException;
import com.tencent.ads.exception.TencentAdsSDKException;
import com.tencent.ads.model.AdCreativeBrand;
import com.tencent.ads.model.AdNum;
import com.tencent.ads.model.AdcreativeCreativeElementsMp;
import com.tencent.ads.model.AdcreativeElementStoryArrayItem;
import com.tencent.ads.model.AdcreativesAddRequest;
import com.tencent.ads.model.AdcreativesAddResponseData;
import com.tencent.ads.model.AdgroupsAddRequest;
import com.tencent.ads.model.AdgroupsAddResponseData;
import com.tencent.ads.model.AdsAddRequest;
import com.tencent.ads.model.AdsAddResponseData;
import com.tencent.ads.model.AgeStruct;
import com.tencent.ads.model.BillingEvent;
import com.tencent.ads.model.CampaignType;
import com.tencent.ads.model.CampaignsAddRequest;
import com.tencent.ads.model.CampaignsAddResponseData;
import com.tencent.ads.model.DestinationType;
import com.tencent.ads.model.DynamicAdSpec;
import com.tencent.ads.model.DynamicAdcreativeSpec;
import com.tencent.ads.model.FilteringStruct;
import com.tencent.ads.model.GeoLocations;
import com.tencent.ads.model.ImagesAddResponseData;
import com.tencent.ads.model.LinkNameType;
import com.tencent.ads.model.OptimizationGoal;
import com.tencent.ads.model.PageSpec;
import com.tencent.ads.model.PromotedObjectType;
import com.tencent.ads.model.PromotedObjectsAddRequest;
import com.tencent.ads.model.PromotedObjectsGetResponseData;
import com.tencent.ads.model.PromotedObjectsUpdateRequest;
import com.tencent.ads.model.WriteTargetingSettingForAdgroup;
import com.tencent.ads.utils.SignatureUtils;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import java.util.UUID;

public class AddDynamicProductAds {
    public String ACCESS_TOKEN = "YOUR ACCESS TOKEN";
    public Long ACCOUNT_ID = 0L;
    public String IOS_APP_ID = "IOS_APP_ID";
    public String IMAGE_PATH = "YOUR AD IMAGE PATH";
    public String BRAND_IMAGE_PATH = "YOUR BRAND AD IMAGE PATH";
    public String AD_PAGE_URL = "YOUR AD PAGE URL";
    public Long PRODUCT_CATALOG_ID = 0L;
    public String PRODUCT_SOURCE = "YOUR PRODUCT SOURCE";
    public static Long ADCREATIVE_TEMPLATE_ID = 725L;
    public static String AD_TITLE = "YOUR AD TEXT";
    public TencentAds tencentAds;
    private SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");

    public void init() {
        this.tencentAds = TencentAds.getInstance();
        this.tencentAds.init(new ApiContextConfig().accessToken(this.ACCESS_TOKEN).isDebug(true));
        this.tencentAds.useSandbox();
    }

    public Long addDynamicProductAds() throws Exception {
        PromotedObjectType promotedObjectType = PromotedObjectType.APP_IOS;
        Long campaignId = this.addCampaign(CampaignType.NORMAL, promotedObjectType);
        String promotedObjectId = this.addPromotedObject(promotedObjectType, this.IOS_APP_ID);
        List<String> siteSet = Arrays.asList("SITE_SET_MOBILE_INNER");
        Long adgroupId = this.addAdgroup(campaignId, promotedObjectType, promotedObjectId, siteSet);
        String imageId = this.addDynamicImage(this.IMAGE_PATH);
        String brandImageId = this.addDynamicImage(this.BRAND_IMAGE_PATH);
        Long adcreativeId = this.addAdcreative(ADCREATIVE_TEMPLATE_ID, campaignId, promotedObjectType, promotedObjectId, siteSet, imageId, brandImageId, AD_TITLE);
        Long adId = this.addAd(adgroupId, adcreativeId);
        return adId;
    }

    private Long addCampaign(CampaignType campaignType, PromotedObjectType promotedObjectType) throws ApiException {
        String campaignName = "SDK\u8ba1\u5212" + UUID.randomUUID().toString().substring(0, 10);
        Long campaignDailyBudget = 100001L;
        CampaignsAddResponseData response = this.tencentAds.campaigns().campaignsAdd(new CampaignsAddRequest().accountId(this.ACCOUNT_ID).campaignName(campaignName).campaignType(campaignType).promotedObjectType(promotedObjectType).dailyBudget(campaignDailyBudget));
        return response.getCampaignId();
    }

    private String addPromotedObject(PromotedObjectType promotedObjectType, String promotedObjectId) throws ApiException {
        PromotedObjectsGetResponseData getResponseData = this.tencentAds.promotedObjects().promotedObjectsGet(this.ACCOUNT_ID, Arrays.asList(new FilteringStruct().field("promoted_object_id").operator("EQUALS").values(Arrays.asList(String.valueOf(promotedObjectId)))), null, null, null);
        if (getResponseData != null && getResponseData.getList().size() > 0) {
            this.tencentAds.promotedObjects().promotedObjectsUpdate(new PromotedObjectsUpdateRequest().accountId(this.ACCOUNT_ID).promotedObjectType(promotedObjectType).promotedObjectId(promotedObjectId));
        } else {
            this.tencentAds.promotedObjects().promotedObjectsAdd(new PromotedObjectsAddRequest().accountId(this.ACCOUNT_ID).promotedObjectType(promotedObjectType).promotedObjectId(promotedObjectId));
        }
        return promotedObjectId;
    }

    private Long addAdgroup(Long campaignId, PromotedObjectType promotedObjectType, String promotedObjectId, List<String> siteSet) throws ApiException {
        String adgroupName = "SDK sample adgroup " + UUID.randomUUID().toString().substring(0, 10);
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, 1);
        String beginDate = this.sdf.format(calendar.getTime());
        calendar.add(5, 6);
        String endDate = this.sdf.format(calendar.getTime());
        BillingEvent billingEvent = BillingEvent.IMPRESSION;
        Long bidAmount = 150L;
        OptimizationGoal optimizationGoal = OptimizationGoal.ECOMMERCE_ORDER;
        String timeSeries = "111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111";
        Long adgroupDailyBudget = 1000000L;
        List<Long> regionIds = Arrays.asList(440300L);
        AdgroupsAddResponseData responseData = this.tencentAds.adgroups().adgroupsAdd(new AdgroupsAddRequest().accountId(this.ACCOUNT_ID).campaignId(campaignId).adgroupName(adgroupName).promotedObjectType(promotedObjectType).beginDate(beginDate).endDate(endDate).billingEvent(billingEvent).bidAmount(bidAmount).optimizationGoal(optimizationGoal).timeSeries(timeSeries).siteSet(siteSet).dailyBudget(adgroupDailyBudget).promotedObjectId(promotedObjectId).targeting(new WriteTargetingSettingForAdgroup().age(Arrays.asList(new AgeStruct().max(60L).min(14L))).gender(Arrays.asList("MALE")).geoLocation(new GeoLocations().locationTypes(Arrays.asList("LIVE_IN")).regions(regionIds))).dynamicAdSpec(new DynamicAdSpec().productCatalogId(this.PRODUCT_CATALOG_ID).productMode(AdNum.SINGLE)));
        return responseData.getAdgroupId();
    }

    private String addDynamicImage(String imageFile) throws Exception {
        String imageSignature = SignatureUtils.getMD5Checksum(imageFile);
        String uploadType = "UPLOAD_TYPE_FILE";
        ImagesAddResponseData responseData = this.tencentAds.images().imagesAdd(this.ACCOUNT_ID, uploadType, imageSignature, new File(imageFile), null, null, null, null, null, null);
        return responseData.getImageId();
    }

    private Long addAdcreative(Long adcreativeTemplateId, Long campaignId, PromotedObjectType promotedObjectType, String promotedObjectId, List<String> siteSet, String imageId, String brandImageId, String adTitle) throws ApiException {
        String adcreativeName = "SDK sample adcreative " + UUID.randomUUID().toString();
        LinkNameType linkNameType = LinkNameType.VIEW_DETAILS;
        DestinationType pageType = DestinationType.DEFAULT;
        AdcreativesAddResponseData responseData = this.tencentAds.adcreatives().adcreativesAdd(new AdcreativesAddRequest().accountId(this.ACCOUNT_ID).campaignId(campaignId).adcreativeName(adcreativeName).adcreativeTemplateId(adcreativeTemplateId).adcreativeElements(new AdcreativeCreativeElementsMp().image(imageId).brand(new AdCreativeBrand().brandImg(brandImageId).brandName("sdk 725" + UUID.randomUUID().toString().substring(0, 10))).title(adTitle).animationEffect("ANIMATION_EFFECT_CIRCLE_TRANSFER").elementStory(Arrays.asList(new AdcreativeElementStoryArrayItem().image(imageId), new AdcreativeElementStoryArrayItem().image(imageId))).buttonText("\u70b9\u51fb\u54a8\u8be2")).promotedObjectType(promotedObjectType).pageType(pageType).pageSpec(new PageSpec().pageUrl(this.AD_PAGE_URL)).siteSet(siteSet).promotedObjectId(promotedObjectId).dynamicAdcreativeSpec(new DynamicAdcreativeSpec().productCatalogId(this.PRODUCT_CATALOG_ID).productMode(AdNum.SINGLE).productSource(this.PRODUCT_SOURCE)).promotedObjectId(promotedObjectId));
        return responseData.getAdcreativeId();
    }

    private Long addAd(Long adgroupId, Long adcreativeId) throws ApiException {
        String adName = "SDK sample ad " + UUID.randomUUID().toString().substring(0, 10);
        AdsAddResponseData responseData = this.tencentAds.ads().adsAdd(new AdsAddRequest().accountId(this.ACCOUNT_ID).adgroupId(adgroupId).adcreativeId(adcreativeId).adName(adName));
        return responseData.getAdId();
    }

    public static void main(String[] args) {
        AddDynamicProductAds addDynamicProductAds = new AddDynamicProductAds();
        addDynamicProductAds.init();
        try {
            Long l = addDynamicProductAds.addDynamicProductAds();
        }
        catch (TencentAdsResponseException e) {
            e.printStackTrace();
        }
        catch (TencentAdsSDKException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

