/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.lbssearch.object.param;

import android.text.TextUtils;
import com.tencent.lbssearch.object.param.RoutePlanningParam;
import com.tencent.lbssearch.object.result.DrivingResultObject;
import com.tencent.map.sdk.a.fn;
import com.tencent.tencentmap.mapsdk.maps.model.LatLng;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class DrivingParam
extends RoutePlanningParam {
    private List<LatLng> a = new ArrayList<LatLng>();
    private String b;
    private String c;
    private String d;
    private String e;
    private int f = -1;
    private int g = -1;
    private int h = -1;
    private RoadType i = RoadType.DEF;
    private Travel j;

    public DrivingParam() {
    }

    public DrivingParam(LatLng from, LatLng to) {
        super(from, to);
    }

    public DrivingParam fromTravel(Travel travel) {
        this.j = travel;
        return this;
    }

    public DrivingParam fromPOI(String fromPOI) {
        this.d = fromPOI;
        return this;
    }

    public DrivingParam toPOI(String toPOI) {
        this.e = toPOI;
        return this;
    }

    public DrivingParam heading(int heading) {
        this.f = heading;
        return this;
    }

    public DrivingParam speed(int speed) {
        this.g = speed;
        return this;
    }

    public DrivingParam accuracy(int accuracy) {
        this.h = accuracy;
        return this;
    }

    public DrivingParam roadType(RoadType roadType) {
        this.i = roadType;
        return this;
    }

    public void setMultyPlan(boolean isMultyPlan) {
    }

    public DrivingParam policy(Policy policy, Preference ... preferences) {
        StringBuilder stringBuilder = new StringBuilder();
        if (policy != null) {
            stringBuilder.append(policy.name());
        }
        if (preferences != null && preferences.length > 0) {
            Preference[] preferenceArray = preferences;
            int n2 = preferences.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Preference preference = preferenceArray[i2];
                stringBuilder.append(",").append(preference.name());
            }
        }
        this.b = stringBuilder.toString();
        return this;
    }

    public DrivingParam policy(RoutePlanningParam.DrivingPolicy policy) {
        StringBuilder stringBuilder = new StringBuilder();
        if (policy != null) {
            stringBuilder.append(policy.name());
        }
        this.b = stringBuilder.toString();
        return this;
    }

    public DrivingParam addWayPoint(LatLng l2) {
        if (this.a.size() < 10) {
            this.a.add(l2);
        }
        return this;
    }

    public DrivingParam addWayPoints(Iterable<LatLng> ls2) {
        if (ls2 != null) {
            int i2 = 0;
            for (LatLng l2 : ls2) {
                this.a.add(l2);
                if (++i2 <= 10) continue;
                return this;
            }
        }
        return this;
    }

    public DrivingParam setCarNumber(String carNumber) {
        this.c = carNumber;
        return this;
    }

    @Override
    public fn buildParameters() {
        fn params = super.buildParameters();
        if (!TextUtils.isEmpty((CharSequence)this.d)) {
            params.a("from_poi", this.d);
        }
        if (!TextUtils.isEmpty((CharSequence)this.e)) {
            params.a("to_poi", this.e);
        }
        if (this.f != -1) {
            params.a("heading", this.f);
        }
        if (this.g != -1) {
            params.a("speed", this.g);
        }
        if (this.h != -1) {
            params.a("accuracy", this.h);
        }
        params.a("road_type", this.i.ordinal());
        if (this.j != null && this.j.points.size() > 0) {
            params.a("from_track", this.j.toString());
        }
        if (this.a.size() > 0) {
            StringBuilder b2 = new StringBuilder();
            for (LatLng l2 : this.a) {
                b2.append(DrivingParam.a(l2));
                b2.append(";");
            }
            b2.setLength(b2.length() - 1);
            params.a("waypoints", b2.toString());
        }
        if (!TextUtils.isEmpty((CharSequence)this.b)) {
            params.a("policy", this.b);
        }
        if (!TextUtils.isEmpty((CharSequence)this.c)) {
            params.a("plate_number", this.c);
        }
        return params;
    }

    @Override
    public String getUrl() {
        return "https://apis.map.qq.com/ws/direction/v1/driving";
    }

    public Class<DrivingResultObject> getResultClass() {
        return DrivingResultObject.class;
    }

    public static class Travel {
        public List<Point> points = new ArrayList<Point>();

        public void addPoints(Point ... points) {
            if (points != null) {
                this.points.addAll(Arrays.asList(points));
            }
        }

        public String toString() {
            int count = this.points.size();
            if (count > 50) {
                count = 50;
            }
            StringBuilder stringBuilder = new StringBuilder();
            for (int i2 = 0; i2 < count; ++i2) {
                stringBuilder.append(this.points.get(i2)).append(";");
            }
            return super.toString();
        }

        public static class Point {
            private LatLng a;
            private int b = -1;
            private int c = -1;
            private int d = -1;
            private int e = -1;
            private int f = 0;

            public Point(LatLng latLng) {
                this.a = latLng;
            }

            public Point setSpeed(int speed) {
                this.b = speed;
                return this;
            }

            public Point setAccuracy(int accuracy) {
                this.c = accuracy;
                return this;
            }

            public Point setDirectionOfCar(int directionOfCar) {
                this.d = directionOfCar;
                return this;
            }

            public Point setDirectionOfDevice(int directionOfDevice) {
                this.e = directionOfDevice;
                return this;
            }

            public Point setTime(int time) {
                this.f = time;
                return this;
            }

            public String toString() {
                StringBuilder stringBuilder = new StringBuilder();
                if (this.a != null) {
                    stringBuilder.append(this.a.latitude).append(",");
                    stringBuilder.append(this.a.longitude).append(",");
                }
                stringBuilder.append(this.b).append(",");
                stringBuilder.append(this.c).append(",");
                stringBuilder.append(this.d).append(",");
                stringBuilder.append(this.e).append(",");
                stringBuilder.append(this.f);
                return stringBuilder.toString();
            }
        }
    }

    public static enum RoadType {
        DEF,
        ABOVE_BRIDGE,
        BELOW_BRIDGE,
        ON_MAIN_ROAD,
        ON_SIDE_ROAD,
        OPPOSITE_SIDE,
        ON_MAIN_ROAD_BELOW_BRIDGE,
        ON_SIDE_ROAD_BELOW_BRIDGE;

    }

    public static enum Preference {
        REAL_TRAFFIC,
        LEAST_FEE,
        AVOID_HIGHWAY,
        NAV_POINT_FIRST;

    }

    public static enum Policy {
        LEAST_TIME,
        PICKUP,
        TRIP;

    }
}

