/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.map.core.functions.animation;

import javax.microedition.khronos.opengles.GL10;

public abstract class GLAnim {
    public static final long ANIM_FIRST_START = -1L;
    public static final int STATE_PENDING = 0;
    public static final int STATE_DRAWING = 1;
    public static final int STATE_FINISHED = 2;
    protected long duration;
    protected int mState;
    private long a;
    private boolean b;
    private long c;

    public GLAnim(long duration) {
        this.duration = duration;
        this.a = -1L;
        this.mState = 0;
    }

    public void setDelay(long delay) {
        this.c = delay;
    }

    public void setRepeat(boolean isRepeat) {
        this.b = isRepeat;
    }

    public long getDuration() {
        return this.duration;
    }

    public void start() {
        this.mState = 1;
        this.a = -1L;
    }

    public void stop() {
        this.mState = 2;
    }

    public boolean isFinished() {
        return this.mState == 2;
    }

    public boolean isDrawing() {
        return this.mState == 1;
    }

    public void draw(GL10 gl2) {
        long usedTime;
        if (this.mState != 1) {
            return;
        }
        if (this.a == -1L) {
            this.a = System.currentTimeMillis();
        }
        if (this.c - (usedTime = System.currentTimeMillis() - this.a) > 0L) {
            return;
        }
        if ((usedTime -= this.c) >= this.duration) {
            if (this.b) {
                this.onRestart();
            }
            this.mState = 2;
        }
        this.performDraw(gl2, usedTime);
    }

    protected void onRestart() {
        this.mState = 1;
        this.a = -1L;
    }

    protected abstract void performDraw(GL10 var1, long var2);
}

