/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.map.core.functions.animation;

import android.os.SystemClock;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import com.tencent.map.lib.basemap.data.GeoPoint;

public abstract class GlAnimation {
    protected long iDuration = 1500L;
    private boolean a = false;
    protected long ltimeStart = 0L;
    private boolean b = false;
    private boolean c = false;
    private Interpolator d = new LinearInterpolator();
    protected InnerAnimationListener animationListener = null;
    protected SetAnimatePropertyListener animationProperty = null;

    public void setAnimationListener(InnerAnimationListener listener) {
        this.animationListener = listener;
    }

    public void setAnimationProperty(SetAnimatePropertyListener property) {
        this.animationProperty = property;
    }

    public void setInterpolator(Interpolator interpolatoe) {
        this.d = interpolatoe;
    }

    public Interpolator getInterpolator() {
        return this.d;
    }

    public void setDuration(long iDurationTime) {
        this.iDuration = iDurationTime;
    }

    public boolean startAnimation(GeoPoint geoFrom, GeoPoint getTo) {
        if (this.iDuration <= 0L) {
            return false;
        }
        this.b = true;
        this.ltimeStart = SystemClock.uptimeMillis();
        this.a = true;
        if (this.animationListener != null) {
            this.animationListener.onAnimationStart();
        }
        return true;
    }

    public void stopAnimation() {
        this.a = false;
    }

    public boolean isRunning() {
        return this.a;
    }

    public void drawAnimation() {
        float f2;
        if (!this.a) {
            if (!this.c && this.animationListener != null) {
                this.animationListener.onAnimationFinish();
            }
            return;
        }
        float fTimeRate = (float)(SystemClock.uptimeMillis() - this.ltimeStart) / (float)this.iDuration;
        if (f2 > 1.0f) {
            this.a = false;
            this.performAnimation(1.0f, this.d);
            if (this.animationListener != null) {
                this.animationListener.onAnimationFinish();
            }
            this.c = true;
            return;
        }
        this.performAnimation(fTimeRate, this.d);
    }

    protected abstract void performAnimation(float var1, Interpolator var2);

    public boolean isStarted() {
        return this.b;
    }

    public boolean isEnded() {
        return this.c;
    }

    public static interface SetAnimatePropertyListener {
        public void setRotate(float var1, float var2, float var3, float var4);

        public void setAlpha(float var1);

        public void setPosition(int var1, int var2);

        public void setScale(float var1, float var2);

        public void setRatio(float var1);
    }

    public static interface InnerAnimationListener {
        public void onAnimationStart();

        public void onAnimationFinish();
    }
}

