/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.map.core.functions.animation;

import android.view.animation.Interpolator;
import com.tencent.map.core.functions.animation.GlAnimation;
import com.tencent.map.lib.basemap.data.GeoPoint;
import java.util.ArrayList;
import java.util.List;

public class GlAnimationSet
extends GlAnimation {
    protected boolean boShareInterpolator = true;
    protected List<GlAnimation> listAnimations = null;

    public GlAnimationSet(boolean shareInterpolator) {
        this.boShareInterpolator = shareInterpolator;
        if (this.listAnimations == null) {
            this.listAnimations = new ArrayList<GlAnimation>();
        }
    }

    public void addAnimation(GlAnimation anim) {
        if (anim == null) {
            return;
        }
        this.listAnimations.add(anim);
    }

    public void cleanAnimation() {
        if (this.listAnimations == null) {
            return;
        }
        this.listAnimations.clear();
    }

    @Override
    protected void performAnimation(float timeEclipseRate, Interpolator inter) {
        if (this.listAnimations == null) {
            return;
        }
        int iSize = this.listAnimations.size();
        if (iSize == 0) {
            return;
        }
        for (int i2 = 0; i2 < iSize; ++i2) {
            GlAnimation animate = this.listAnimations.get(i2);
            if (animate == null) continue;
            if (this.boShareInterpolator) {
                animate.performAnimation(timeEclipseRate, inter);
                continue;
            }
            animate.performAnimation(timeEclipseRate, animate.getInterpolator());
        }
    }

    @Override
    public boolean startAnimation(GeoPoint geoFrom, GeoPoint getTo) {
        boolean boResult = super.startAnimation(geoFrom, getTo);
        if (!boResult) {
            return false;
        }
        if (this.listAnimations == null) {
            return false;
        }
        int iSize = this.listAnimations.size();
        if (iSize == 0) {
            return false;
        }
        for (int i2 = 0; i2 < iSize; ++i2) {
            GlAnimation animate = this.listAnimations.get(i2);
            if (animate == null) continue;
            boResult = boResult && animate.startAnimation(geoFrom, getTo);
        }
        return boResult;
    }

    @Override
    public void setAnimationProperty(GlAnimation.SetAnimatePropertyListener property) {
        super.setAnimationProperty(property);
        if (this.listAnimations == null) {
            return;
        }
        int iSize = this.listAnimations.size();
        if (iSize == 0) {
            return;
        }
        for (int i2 = 0; i2 < iSize; ++i2) {
            GlAnimation animate = this.listAnimations.get(i2);
            if (animate == null) continue;
            animate.setAnimationProperty(property);
        }
    }
}

